-- phpMyAdmin SQL Dump
-- version 5.1.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Feb 01, 2022 at 09:05 PM
-- Server version: 10.3.16-MariaDB
-- PHP Version: 7.4.21

SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `projectmanagement`
--
CREATE DATABASE IF NOT EXISTS `projectmanagement` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
USE `projectmanagement`;

DELIMITER $$
--
-- Procedures
--
DROP PROCEDURE IF EXISTS `sp_Chart_GetNumberOfProjectsValue`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_Chart_GetNumberOfProjectsValue` (IN `yearFrom` INT, IN `yearTo` INT, IN `ProjectCategoryId` BIGINT, IN `ProjectStatusId` BIGINT)  BEGIN
select year(p.startDate) as ProjectYear, sum(p.projectPrice) as ProjectPrice, count(p.id) as ProjectCount
from project p 
where p.deactivationDate is null and year(p.startDate) >= yearFrom
and year(p.endDate) <= yearTo and (p.ProjectCategoryId = ProjectCategoryId or ProjectCategoryId is null) 
and (p.ProjectStatusId = ProjectStatusId or ProjectStatusId is null) group by year(p.startDate);
END$$

DROP PROCEDURE IF EXISTS `sp_GetActivityAmountsByYearAndProject`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetActivityAmountsByYearAndProject` (IN `ProjectId` BIGINT, IN `Year` BIGINT)  BEGIN
select 
	month(activity.startDate) as ActivityMonth,
	sum(price) as MonthAmount,
	(select  code from Currency where id in (select currencyId from project where project.id = ProjectId) limit 0,1) as Currency
	
from 
	activity inner join project
    ON project.ID=activity.projectID
where 
	activity.projectId = ProjectId and
	year(activity.StartDate) = Year
group by 
	month(activity.startDate);
END$$

DROP PROCEDURE IF EXISTS `sp_GetFinanceByUsers`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetFinanceByUsers` (IN `ProjectUserId` BIGINT, IN `ProjectCategoryId` BIGINT, IN `ProjectId` BIGINT, IN `YearFrom` INT, IN `YearTo` INT, IN `ProjectStatusId` BIGINT, IN `language` VARCHAR(20))  BEGIN
select 
	sum(Project.ProjectPrice) as Amount,
	ProjectUserLocalized.Name as ProjectUserName
from
	Project 
	inner join ProjectProjectUser on ProjectProjectUser.ProjectId = Project.Id
	inner join ProjectUserLocalized on ProjectProjectUser.ProjectUserId = ProjectUserLocalized.ParentId and ProjectUserLocalized.LanguageCode = language
where 
	(ProjectUserLocalized.ParentId = ProjectUserId or ProjectUserId is null) and
	(Project.Id =  ProjectId or ProjectId is null) and
	(Project.ProjectCategoryId =  ProjectCategoryId or  ProjectCategoryId is null) and
	(Project.ProjectStatusId =  ProjectStatusId or  ProjectStatusId is null) and
	(year(Project.StartDate) >=  YearFrom or  YearFrom is null) and
	(year(Project.StartDate) <=  YearTo or  YearTo is null) 
	
group by ProjectUserLocalized.Name;
END$$

DROP PROCEDURE IF EXISTS `sp_GetFinanceReview`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetFinanceReview` (IN `OrganizationUnitId` BIGINT, IN `ProjectCategoryId` BIGINT, IN `ProjectId` BIGINT, IN `YearFrom` INT, IN `YearTo` INT, IN `ProjectStatusId` BIGINT, IN `language` VARCHAR(20))  BEGIN

select 
	sum(projectBudget.ComputedValue) as Amount,
	orgUnit.Name as OrgUnitName
from
	ProjectBudget projectBudget
	inner join OrganizationUnitLocalized orgUnit on projectBudget.OrganizationUnitId = orgUnit.ParentId and orgUnit.LanguageCode =  language
	inner join Project on projectBudget.ProjectId = Project.Id
where 
	
	(projectBudget.OrganizationUnitId =  OrganizationUnitId or  OrganizationUnitId is null) and
	(Project.Id =  ProjectId or  ProjectId is null) and
	(Project.ProjectCategoryId =  ProjectCategoryId or  ProjectCategoryId is null) and
	(Project.ProjectStatusId =  ProjectStatusId or  ProjectStatusId is null) and
	(year(Project.StartDate) >=  YearFrom or  YearFrom is null) and
	(year(Project.StartDate) <=  YearTo or  YearTo is null) 
	
group by orgUnit.Name
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetFundsByCategories`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetFundsByCategories` (IN `ProjectCategoryId` INT, IN `YearFrom` BIGINT, IN `YearTo` BIGINT, IN `ProjectStatusId` INT, IN `language` VARCHAR(20))  SELECT t.StartDateYear,t.CategoryName,
SUM(t.Amount) as Amount
FROM
(select 	year(p.StartDate) as StartDateYear,
	pc.Name as CategoryName,
	p.ProjectPrice as Amount
	
from
	project as p inner join ProjectCategoryLocalized as pc 
    on p.ProjectCategoryId = pc.ParentId and pc.LanguageCode =  language
where 
	(pc.ParentId =  ProjectCategoryId or  ProjectCategoryId is null) and
	(p.ProjectStatusId =  ProjectStatusId or  ProjectStatusId is null) and
	(year(p.StartDate) >=  YearFrom) and
	(year(p.StartDate) <=  YearTo) 
	and p.ProjectPrice is not null and p.DeactivationDate is null) as t
group by t.StartDateYear, t.CategoryName$$

DROP PROCEDURE IF EXISTS `sp_GetNumberOfProjectsAndAveragePrice`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetNumberOfProjectsAndAveragePrice` (IN `yearFrom` BIGINT, IN `yearTo` BIGINT, IN `categoryId` INT)  BEGIN
SELECT t.TotalPrice,
t.ProjectCount,
case when t.ProjectCount > 0 then
		t.TotalPrice/ t.ProjectCount
	else 0 end as AveragePrice
    FROM (select	sum(p.projectPrice) as TotalPrice,
	count(p.id) as ProjectCount 
from 	project as p
where
	p.deactivationDate is null
	and year(p.startDate) >= yearFrom
	and year(p.endDate) <= yearTo
	and (categoryId is null or p.projectCategoryId = categoryId)) as t
    ;
    END$$

DROP PROCEDURE IF EXISTS `sp_GetNumberOfProjectsByAccordance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetNumberOfProjectsByAccordance` (IN `accordanceId` BIGINT, IN `dateFrom` DATE, IN `dateTo` DATE, IN `ProjectCategoryId` BIGINT, IN `ProjectId` BIGINT, IN `ProjectStatusId` BIGINT, IN `language` VARCHAR(20))  BEGIN

select 
	accordance.Name as AccordanceName,
	(select SUM(pBudget.ComputedValue) 
		from project project2 
		inner join ProjectBudget as pBudget 
		on project2.Id = pBudget.ProjectId 
		where project2.ProjectInAccordanceWithId =  p.ProjectInAccordanceWithId) as ProjectPrice,
	count(p.id) as ProjectCount
from 
	project p
	inner join ProjectInAccordanceWithLocalized accordance on accordance.ParentId = p.ProjectInAccordanceWithId
where
	p.deactivationDate is null
	and p.startDate >=  dateFrom
	and p.endDate <=  dateTo
	and (accordance.Id =  accordanceId or  accordanceId is null) and
	(p.ProjectCategoryId =  ProjectCategoryId or  ProjectCategoryId is null) and
	(p.ProjectStatusId =  ProjectStatusId or  ProjectStatusId is null) and
	accordance.LanguageCode =  language
group by 
	 accordance.Name , p.ProjectInAccordanceWithId
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetNumberOfProjectsByDate`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetNumberOfProjectsByDate` (IN `dateFrom` DATE, IN `dateTo` DATE, IN `ProjectCategoryId` BIGINT, IN `ProjectId` BIGINT, IN `ProjectStatusId` BIGINT)  BEGIN

select 
	year(p.startDate) as ProjectYear,
	(select SUM(pBudget.ComputedValue) 
		from project project2 
		inner join ProjectBudget as pBudget 
		on project2.Id = pBudget.ProjectId 
		where year(project2.startDate) =  year(p.startDate)) as ProjectPrice,
	count(p.id) as ProjectCount
from 
	project p
where
	p.deactivationDate is null
	and p.startDate >=  dateFrom
	and p.endDate <=  dateTo and
	(p.ProjectCategoryId =  ProjectCategoryId or  ProjectCategoryId is null) and
	(p.ProjectStatusId =  ProjectStatusId or  ProjectStatusId is null)
group by 
	year(p.startDate)
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivities`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivities` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  SELECT 
nomenclature,Name,StartDate,EndDate,Progress,id,parentid,
ActivityUsers,Price,Currency,CAST(nomenclature as Decimal(18,1)) as red
FROM (
    SELECT 
		a1.ordinalnumber as nomenclature,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null
UNION ALL
 SELECT 
		CONCAT(a2.ordinalnumber,'.',c.nomenclature)  as nomenclature,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
      c.ActivityUsers,
	 a2.Price,
	 c2.symbol as Currency
    FROM Activity as a2
    inner join Project as p2 on p2.id = a2.projectId
    inner join currency as c2 on p2.currencyId = c2.id
      INNER JOIN (SELECT 
		a1.ordinalnumber as nomenclature,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY  a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		a1.ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null) as c
        ON a2.Id = c.Parentid
    WHERE
    a2.ProjectId =  ProjectId
		and a2.DeactivationDate is null
      
) as hllss
ORDER BY CAST(nomenclature as Decimal(18,1))$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivities1`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivities1` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

SELECT 
nomenclature,Name,StartDate,EndDate,Progress,id,parentid,
ActivityUsers,Price,Currency
FROM  tabelaakt1
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivities2`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivities2` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

SELECT 
nomnumb,CAST(nomnumb as decimal(18,14)) as decimale,nomenclature,Name,StartDate,EndDate,Progress,id,parentid,
ActivityUsers,Price,Currency
FROM  tabelaakt1
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivitiesGantt`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivitiesGantt` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 	a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId and a1.DeactivationDate IS NULL;
        
INSERT INTO tabelaakt2
SELECT	a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
        
INSERT INTO tabelaakt1
SELECT	CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
SET @rank=0;
SELECT nomenclature as ordinalnumb,Id,Name,Description,StartDate,EndDate,Duration,
WorkingFund,Price,
ParentId,PriorityId,Progress,EstimatedTimeHours,EstimatedTimeMinutes,
Activated,DateCreated,CreatedBy,DeactivationDate,ProjectId,CurrencyId,OrdinalNumber,IsClosed,
IsMilestone,SolveDate,Assigned,Summary,@rank:=@rank+1 AS ranking
FROM
(SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.ParentId is null and a.IsMilestone=false
UNION
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.ParentId IS NOT NULL
UNION
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.EndDate as StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.IsMilestone=true) as srcact
ORDER BY CAST(nomenclature as decimal(18,14));
DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivitiesGanttChild`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivitiesGanttChild` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.ParentId IS NOT NULL
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivitiesGanttMilest`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivitiesGanttMilest` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,

		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.EndDate as StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.IsMilestone=true
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivitiesGantt_update`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivitiesGantt_update` (IN `ProjectId` INT, IN `language` VARCHAR(20), IN `userId` VARCHAR(50), IN `ordinalnumber` VARCHAR(20))  BEGIN

INSERT INTO tabelaakt1
SELECT 	a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId and a1.DeactivationDate IS NULL;
        
INSERT INTO tabelaakt2
SELECT	a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
        
INSERT INTO tabelaakt1
SELECT	CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
	 0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
UPDATE `tabelaakt1`, `tabelaakt2`
SET `tabelaakt1`.Summary=1
WHERE tabelaakt1.id=tabelaakt2.parentId and tabelaakt1.projectId=tabelaakt2.projectId and tabelaakt1.userId=tabelaakt2.userId and tabelaakt2.Nivo=0;

SELECT nomenclature as ordinalnumb,Id
FROM
(SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.ParentId is null and a.IsMilestone=false
UNION
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.ParentId IS NOT NULL
UNION
SELECT 
ta.nomenclature,ta.Id,a.Name,a.Description,a.EndDate as StartDate,a.EndDate,a.Duration,
a.WorkingFund,a.Price,
a.ParentId,a.PriorityId,a.Progress,a.EstimatedTimeHours,a.EstimatedTimeMinutes,
a.Activated,a.DateCreated,a.CreatedBy,a.DeactivationDate,a.ProjectId,a.CurrencyId,a.OrdinalNumber,a.IsClosed,
a.IsMilestone,a.SolveDate,ta.ActivityUsers as Assigned,ta.Summary
FROM  tabelaakt1 as ta inner join activity as a ON ta.id=a.id and ta.ProjectId=a.projectId and ta.userId=userId
WHERE a.IsMilestone=true) as srcact
WHERE nomenclature=ordinalnumber
ORDER BY CAST(nomenclature as decimal(18,14));
DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivitiesNew`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivitiesNew` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `UserId` VARCHAR(50))  BEGIN

INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

SELECT 
ta.nomenclature,ta.Name,CASE WHEN Length(ac.Description) > 255 THEN LEFT(ac.Description,255) ELSE ac.Description END as Description ,ta.StartDate,ta.EndDate,ac.SolveDate,ppl.Name as PriorityName,ta.Progress,ta.id,ta.parentid,
ta.ActivityUsers,CAST(ta.Price as decimal(18,2)) as Price,ta.Currency,ac.WorkingFund,tus.Hours+(tus.minutes div 60) as Hours,
(tus.minutes mod 60) as Minutes,tus.HoursPay+(tus.MinutesPay div 60) as HoursPay,
(tus.MinutesPay mod 60) as MinutesPay,Cast(tus.trosakvremena as decimal(18,2)) as trosakvremena,Cast(ex.Costs as decimal(18,2)) as Costs ,Cast(ex.PlannedCosts as decimal(18,2)) as PlannedCosts,
Cast(acr.CostsRes as decimal(18,2)) as CostsRes,Cast(ta.Price as decimal(18,2)) as TotalCosts
FROM  tabelaakt1 ta join activity ac ON ta.id=ac.id
join projectprioritylocalized ppl on ac.PriorityId=ppl.PriorityId and ppl.LanguageCode=language
left join 
(select ac1.Id, sum(tu.Hours) as Hours, sum(minutes) as minutes,
SUM( CASE WHEN Payable THEN tu.Hours ELSE 0 END) as HoursPay,SUM( CASE WHEN Payable THEN tu.Minutes ELSE 0 END) as MinutesPay,
SUM(Amount) as trosakvremena from activity ac1 left join timeuse tu on ac1.id=tu.ActivityId group by ac1.Id) as tus
ON ac.Id=tus.id
left join (select ActivityId,Sum(Price) as Costs, SUM( CASE WHEN IsPlanned THEN Price ELSE 0 END) as PlannedCosts from expense group by ActivityId) as ex
on ac.Id=ex.ActivityId
left join (select ActivityId,SUM(Cost) as CostsRes from activityresource group by ActivityId) as acr
ON ac.Id=acr.ActivityId
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId=userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId=userId; 

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivityNewByResources`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivityNewByResources` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;

select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as Name,
	a.name as Activity,
    a.Description as ActivityDescription,
    (SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a.Id
			    GROUP BY a.Id) as ActivityUsers,
	sum(ar.Amount) as ActualAmount,
    ar.UnitPrice as JedCijena,
	sum(ar.Cost) as ActualCost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	a.name,
    a.Description,
    ActivityUsers,
	c.Symbol
order by Activity,@row_number asc
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivityNewByResourcesGroup`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivityNewByResourcesGroup` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;
select distinct h1r.Name,
h1r.PlanedAmount,
h1r.PlanedCost,
h1r.Value,
h1r.Currency
from
(select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as Name,
	rt.name as ResourceType,
	a.name as Activity,
    a.StartDate as ActivityStartDate,
    a.EndDate as ActivityEndDate,
    a.Description as ActivityDescription,
    (SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a.Id
			    GROUP BY a.Id) as ActivityUsers,
	ar.ResourceDescription,
   	sum(ar.Amount) as ActualAmount,
    sum(pr.PlanedAmount) as PlanedAmount,
    sum(pr.PlanedAmount * pr.Cost) as PlanedCost,
    ar.UnitPrice as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as ActualCost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	rt.name,
	a.name,
    a.StartDate,
    a.EndDate,
    a.Description,
    ActivityUsers,
	ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc
) as h1r;

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivityNewByResourcesSum`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivityNewByResourcesSum` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;
select h1r.Name,
h1r.Currency,
Sum(h1r.ActualCost) as Cost,
Sum(h1r.ActualAmount) as Amount
from
(select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as Name,
	rt.name as ResourceType,
	a.name as Activity,
    a.StartDate as ActivityStartDate,
    a.EndDate as ActivityEndDate,
    a.Description as ActivityDescription,
    (SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a.Id
			    GROUP BY a.Id) as ActivityUsers,
	ar.ResourceDescription,
   	sum(ar.Amount) as ActualAmount,
    sum(pr.PlanedAmount) as PlanedAmount,
    sum(pr.PlanedAmount * pr.Cost) as PlanedCost,
    ar.UnitPrice as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as ActualCost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	rt.name,
	a.name,
    a.StartDate,
    a.EndDate,
    a.Description,
    ActivityUsers,
	ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc) as h1r
group by h1r.Name,
h1r.Currency;

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectActivityUpdates`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectActivityUpdates` (IN `ProjectId` BIGINT)  BEGIN
select
	u.name as UserName,
	au.ActivityUpdate,
	au.DateCreated,
	a.name as Activity
from 
	activityUpdate au
	inner join user u on u.id = au.CreatedBy	
	inner join activity a on a.id = au.activityId
Where
	a.ProjectId =  ProjectId
	and au.deactivationDate is null
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectAlterations`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectAlterations` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select 
	alt.name as AlterationName,
	case when alt.IsClosed = 0 then 
    (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
     CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else
     CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
     CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
     CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end) 
    end as IsClosed,
	(SELECT Group_concat(DISTINCT COALESCE(User.name,' ')  SEPARATOR ";")
				FROM User inner join alterationUser
     ON User.Id=alterationUser.UserId
				Where alterationUser.alterationId=alt.id
                GROUP BY alt.Id) as AlterationUsers,
		(SELECT Group_concat(DISTINCT COALESCE(activity.name,' ')  SEPARATOR ";") 
				FROM activity inner join alterationActivity
         ON activity.Id=AlterationActivity.ActivityId
				where alterationActivity.deactivationDate is null
                          and           alterationActivity.AlterationId=alt.Id
				GROUP BY alt.Id) as AlterationActivities,
	case when influence is not null then
		case
			when influence = 1 then
            (case when language='sr-Latn-CS' then 'Visok' else
             case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else 
             case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else 
             'High' end end end end end end end end end)
			when influence = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
             case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else
             case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end 
              end end end end end)
			when influence = 3 then 
            (case when language='sr-Latn-CS' then 'Nizak' else 
             case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else
             case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
				case when language='es-SE' then 'Bajo' else			 
             'Low' end end end end end end end end end)
		else '' 
        end
	else '' 
    end as Influence,            	 
	case when priority is not null then
		case 
			when priority = 1 then
            (case when language='sr-Latn-CS' then 'Visok' else 
             case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else
             case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else
             'High' end end end end end end end end end)
			when priority = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
             case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else 
             case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end end end end end
              end)
			when priority = 3 then 
            (case when language='sr-Latn-CS' then 'Nizak' else 
              case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else
             case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
			 	case when language='es-SE' then 'Bajo' else	
             'Low' end end end end end end end end  end)
		else '' end
	else '' end as priority,             
	case when solveDate is null then 
    (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
     CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else
     CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else
	 'No' end end end end end end end end end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
     CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
     CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else
	 'Yes' end end end end end end end end end) 
    end as Solved
	
from 
	alteration as alt
where
alt.projectId =  ProjectId
	and alt.deactivationDate is null$$

DROP PROCEDURE IF EXISTS `sp_GetProjectAssignementsGantt`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectAssignementsGantt` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  SELECT `activityresource`.Id,`activityresource`.Id,ActivityId,Allocation
FROM `activityresource` inner join `activity` ON
`activityresource`.ActivityId=`activity`.Id
WHERE `activity`.`ProjectId`=ProjectId and activityresource.DeactivationDate is null$$

DROP PROCEDURE IF EXISTS `sp_GetProjectBasicData`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectBasicData` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select
	p.Name,
	pc.name as ProjectCategory,
	ps.name as ProjectStatus,
	p.ProjectPrice,
	(SELECT Group_Concat(DISTINCT user.name SEPARATOR ';')  
				FROM userproject inner join user ON userproject.userid=user.Id
				where userproject.projectId = projectId and userproject.roleid=2
      GROUP BY userproject.projectId) as Manager,
	p.StartDate,
	p.EndDate,
	p.ProjectNumber,
	curr.Symbol as CurrencySymbol,
	(SELECT  Group_Concat(DISTINCT name SEPARATOR ';') 
				FROM ProjectApplied
				where id in (select ProjectAppliedId from ProjectProjectApplied
							 where ProjectProjectApplied.projectId = projectId and ProjectProjectApplied.deactivationDate is null)
		GROUP BY p.Id
	 ) as ProjectApplied,
	 (SELECT Group_Concat(DISTINCT name SEPARATOR ';')  
				FROM ProjectUser inner join ProjectProjectUser ON ProjectUser.id=ProjectProjectUser.ProjectUserId
				where ProjectProjectUser.projectId = projectId and ProjectProjectUser.deactivationDate is null
      GROUP BY ProjectProjectUser.projectId) as ProjectUsers,
		(Select Group_concat(DISTINCT ProjectLocationLocalized.Name SEPARATOR ';') From ProjectLocationLocalized  
		INNER JOIN ProjectProjectLocation as PPL on PPL.ProjectLocationId = ProjectLocationLocalized.Code and ProjectLocationLocalized.LanguageCode=language  where PPL.ProjectId=projectId and PPL.DeactivationDate IS NULL 
	GROUP BY PPL.ProjectId) as ProjectLocations,
	
	paw.Name as AccordanceWith
	
from 
	project as p
	left join ProjectCategoryLocalized as pc on p.ProjectCategoryId = pc.code and pc.LanguageCode=language
	inner join User as u on u.id = p.ManagerId
	left join ProjectLocationLocalized as pl on p.ProjectLocationId=pl.code and pl.LanguageCode=language
	left join ProjectInAccordanceWithLocalized as paw on paw.code = p.ProjectInAccordanceWithId and paw.LanguageCode=language
	left join Currency as curr on curr.Id = p.CurrencyId
	inner join ProjectStatusLocalized as ps on ps.Code = p.ProjectStatusId and ps.LanguageCode=language
WHERE p.Id=projectId$$

DROP PROCEDURE IF EXISTS `sp_GetProjectBasicDataNew`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectBasicDataNew` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select
	p.Name,
	pc.name as ProjectCategory,
	ps.name as ProjectStatus,
	p.ProjectPrice,
	(SELECT Group_Concat(DISTINCT user.name SEPARATOR ';')  
				FROM userproject inner join user ON userproject.userid=user.Id
				where userproject.projectId = projectId and userproject.roleid=2
      GROUP BY userproject.projectId) as Manager,
	p.StartDate,
	p.EndDate,
	p.ProjectNumber,
	curr.Symbol as CurrencySymbol,
	(SELECT  Group_Concat(DISTINCT name SEPARATOR ';') 
				FROM ProjectApplied
				where id in (select ProjectAppliedId from ProjectProjectApplied
							 where ProjectProjectApplied.projectId = projectId and ProjectProjectApplied.deactivationDate is null)
		GROUP BY ProjectApplied.Id
	 ) as ProjectApplied,
	 (SELECT Group_Concat(DISTINCT name SEPARATOR ';')  
				FROM ProjectUser inner join ProjectProjectUser ON ProjectUser.id=ProjectProjectUser.ProjectUserId
				where ProjectProjectUser.projectId = projectId and ProjectProjectUser.deactivationDate is null
      GROUP BY ProjectProjectUser.projectId) as ProjectUsers,
		(Select Group_concat(DISTINCT ProjectLocationLocalized.Name SEPARATOR ';') From ProjectLocationLocalized  
		INNER JOIN ProjectProjectLocation as PPL on PPL.ProjectLocationId = ProjectLocationLocalized.Code and ProjectLocationLocalized.LanguageCode=language  where PPL.ProjectId=projectId and PPL.DeactivationDate IS NULL 
	GROUP BY PPL.ProjectId) as ProjectLocations,
	
	paw.Name as AccordanceWith,
h1.ResourceCosts as ResourceCosts,
h2.PlanedResourceCosts as PlanedResourceCosts

from 
	project as p
	left join ProjectCategoryLocalized as pc on p.ProjectCategoryId = pc.code and pc.LanguageCode=language
	inner join User as u on u.id = p.ManagerId
	left join ProjectLocationLocalized as pl on p.ProjectLocationId=pl.code and pl.LanguageCode=language
	left join ProjectInAccordanceWithLocalized as paw on paw.code = p.ProjectInAccordanceWithId and paw.LanguageCode=language
	left join Currency as curr on curr.Id = p.CurrencyId
	inner join ProjectStatusLocalized as ps on ps.Code = p.ProjectStatusId and ps.LanguageCode=language
    left join 	(select 
a.ProjectId,
	sum(ar.Cost) as ResourceCosts
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by a.ProjectId) as h1 ON p.id = h1.ProjectId
left join (select 
a.ProjectId,
	sum(pr.PlanedAmount) as PlanedResourceCosts
 from
	activity as a
    inner join activityResource as ar on ar.activityId = a.id
	inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by a.ProjectId) as h2 ON p.id = h2.ProjectId
WHERE p.Id=projectId$$

DROP PROCEDURE IF EXISTS `sp_GetProjectDemographicData`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectDemographicData` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN
select 
	pdd.NumberOfUsers,
	pu.Name as ProjectUser,
	case when genderPresence = 1 then 'Da' else 'Ne' end as GenderPresence,
	pdd.Men,
	pdd.Women,
	pdd.Children,
	pdd.Unknown
	from 
	projectDemographicData pdd
	inner join projectUser pu on pdd.projectUserId = pu.id
where
	pdd.projectId =  ProjectId
	and pdd.deactivationDate is null
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectExpenses`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectExpenses` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select 
	e.name as ExpenseName,
	case when ISNULL(e.isPlanned) = 1 then 
    (CASE when language='sr-Latn-CS' then 'Ne' else 
     CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end)
    else (Case when language='sr-Latn-CS' then 'Da' else 
          CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end) end as IsPlanned,
	et.name as ExpenseType,
	a.name as Activity,
	e.ExpenseDate,
e.Price  as ExpensePrice,
    c.symbol as CurrencySymbol,
	e.UnitOfMeasure,
	e.Quantity,
    e.PriceByUnitOfMeasure as PriceByUnitOfMeasure,
	e.TaxPercentage as Tax,
e.Price- e.TaxPercentage as PriceWithoutTax

from 
	expense as e
	inner join project as p on p.id = e.projectId
	left join currency as c on c.id = p.currencyId
	inner join expenseTypelocalized as et on e.expenseTypeId=et.code 
	left join activity as a on a.id = e.activityId
where
	e.projectId =  ProjectId
	and e.deactivationDate is null
    and et.LanguageCode=language$$

DROP PROCEDURE IF EXISTS `sp_GetProjectExpensesSeparated`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectExpensesSeparated` (IN `ProjectId` BIGINT, IN `IsAlternative` BIT, IN `IsPlanned` BIT, IN `ExpenseTypeId` INT, IN `language` VARCHAR(20), IN `dateFrom` DATE, IN `dateTo` DATE)  select htll.name,
htll.ExpenseType,
htll.Activity,
htll.Description,
htll.ExpenseDate as Datum,
htll.IsPlanned,
htll.Price,
htll.Currency,
htll.UnitOfMeasure,
htll.Quantity,
htll.PriceByUnitOfMeasure,
htll.Tax,
htll.PriceWithoutTax
     
FROM (select
	e.Name,
	et.name as ExpenseType,
	a.name as Activity,
	 e.Description,
	 e.ExpenseDate,
	 case when IFNULL(e.IsPlanned,0)= 0 then 
	 (case when  language = 'sr-Latn-CS' then 'Ne' else 
      CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end) else (case when  language = 'sr-Latn-CS' then 'Da' else 
           CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end) end as IsPlanned,
	 case when IFNULL(IsAlternative,0) = 0
		 then 
      COALESCE(e.Price,0)
		 else 
      (CASE WHEN e.IsAlternativeCurrency=0 THEN
      COALESCE(e.Price,0)
      else
      COALESCE(e.PriceAlternative,0) 
      end)
	 end as Price,
	  case when IFNULL(IsAlternative,0) = 0 then
	 (select  COALESCE(symbol,'') as symbol from currency inner join project ON currency.Id=project.CurrencyId where project.Id=ProjectId)
	 else
      (CASE WHEN e.IsAlternativeCurrency=0 THEN
      	 	  (select  COALESCE(symbol,'') as symbol from currency inner join project ON currency.Id=project.CurrencyId where project.Id=ProjectId)
      else
       (select COALESCE(symbol,'') as symbol from currency where currency.Id=e.AlternativeCurrencyId order by symbol) end)
      end  as Currency,
	  e.UnitOfMeasure,
		e.Quantity,
	case when IFNULL(IsAlternative,0) = 0
	then COALESCE(e.PriceByUnitOfMeasure,0)
	else
      (CASE WHEN e.IsAlternativeCurrency=0 THEN
      COALESCE(e.PriceByUnitOfMeasure,0)
      else
      COALESCE(e.PriceByUnitOfMeasureAlternative,0) end) end as PriceByUnitOfMeasure,
	case when IFNULL(IsAlternative,0) = 0
	then COALESCE(e.TaxPercentage,0) 
	else
      (CASE WHEN e.IsAlternativeCurrency=0 THEN
      COALESCE(e.TaxPercentage,0)
      else
      COALESCE(e.TaxAmountAlternative,0) end) end	as Tax,
	case when IFNULL(IsAlternative,0) = 0
	then 
		COALESCE(e.Price, 0) - COALESCE(e.TaxPercentage, 0) 
	else
      (CASE WHEN e.IsAlternativeCurrency=0 THEN
      COALESCE(e.Price, 0) - COALESCE(e.TaxPercentage, 0)
      else
	COALESCE(e.PriceAlternative, 0) - COALESCE(e.TaxAmountAlternative, 0) end)
	end as PriceWithoutTax
from
	Expense as e
	inner join project as p on e.projectId=p.id 
	left join ExpenseTypeLocalized as et on e.expenseTypeId = et.ParentId and  et.LanguageCode =  language
	left join activity as a on a.id = e.activityId
where 
	e.ProjectId =  ProjectId
    and (e.expenseTypeId=ExpenseTypeId or ExpenseTypeId is null) 
	and e.DeactivationDate is null
     and (e.IsPlanned=IsPlanned or IsPlanned is null)
      and (e.ExpenseDate >= dateFrom or dateFrom is null)
      and (e.ExpenseDate <= dateTo or dateTo is null)
     ) as htll 
Order by htll.name$$

DROP PROCEDURE IF EXISTS `sp_GetProjectExpensesSeparatedChart`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectExpensesSeparatedChart` (IN `ProjectId` BIGINT, IN `IsAlternative` BIT, IN `ProjectCategoryId` BIGINT, IN `IsPlanned` BIT, IN `ExpenseTypeId` BIGINT, IN `language` VARCHAR(20))  BEGIN

select
	et.name as ExpenseType,
	 sum(case when IFNULL( IsAlternative, 0) = 0
		 then e.Price
		 else e.PriceAlternative 
	 end) as Price
from
	Expense as e
	inner join project as p on p.id = e.projectId
	left join ExpenseTypeLocalized as et on e.expenseTypeId = et.ParentId and  et.LanguageCode =  language
	left join activity as a on a.id = e.activityId

where 
	e.ProjectId =  ProjectId 
	and ( ProjectCategoryId is null or p.ProjectCategoryId =  ProjectCategoryId) 
	and ( ExpenseTypeId is null or e.ExpenseTypeId =  ExpenseTypeId) 
	and ( IsAlternative is null or  IFNULL(e.IsAlternativeCurrency, 0) =  IsAlternative)
	and ( IsPlanned is null or IFNULL(e.IsPlanned, 0) =  IsPlanned)
	and e.DeactivationDate is null 
group by et.name
Order by et.name


;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectMilestones`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectMilestones` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select 
	
	case when a.IsClosed = 0 then 
    (Case when language='sr-Latn-CS' then 'Ne' else 
     CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end) else(Case when language='sr-Latn-CS' then 'Da' else 
  CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end) end as IsClosed,
	(SELECT Group_concat(DISTINCT COALESCE(User.name,' ')  SEPARATOR ";")
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				 where activityId = a.id
     GROUP BY ActivityUser.ActivityId
) as MilestoneUsers,
	a.name as Activity,
	a.StartDate,
	a.EndDate

from 
activity a 

where
	a.projectId =  ProjectId
	and a.deactivationDate is null
	and a.isMilestone = 1$$

DROP PROCEDURE IF EXISTS `sp_GetProjectPlanBudget`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectPlanBudget` (IN `ProjectId` BIGINT)  BEGIN

select 
	ou.name as InstitutionOrganization,
	pb.value as Amount,
	c.Symbol as Currency,
	pb.computedValue as ComputedValue,
	c2.Symbol as ComputedCurrency
	
from 
	projectBudget pb
	inner join organizationUnit ou on pb.organizationUnitId = ou.id
	inner join currency c on pb.currencyId = c.id
	left join currency c2 on pb.computedCurrencyId = c2.id
where
	pb.ProjectId =  ProjectId
	and pb.deactivationDate is null

;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectProblems`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectProblems` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  select 
	p.name as ProblemName,
	case when p.IsClosed = 0 then 
   (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
    CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
     CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end) 
    end as IsClosed,
    
	(SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")				
				FROM User inner join problemUser
     ON User.Id=problemUser.UserId
				where problemId = p.id
				GROUP BY problemUser.ProblemId) as ProblemUsers,
     
		(SELECT Group_concat(DISTINCT COALESCE(activity.Name,' ') SEPARATOR ";")  
				FROM activity inner join problemActivity
         ON activity.Id=problemActivity.ActivityId
				where problemActivity.problemId = p.id
				and p.ProjectId=ProjectId
				GROUP BY p.ProjectId,problemActivity.ProblemId) as ProblemActivities,
	case when influence is not null then
		case 
			when influence = 1 then
            (case when language='sr-Latn-CS' then 'Nizak' else 
             case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else 
			 case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
				case when language='es-SE' then 'Bajo' else			 
             'Low' end end end end end end end end end)
			when influence = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
             case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else 
			 case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end 
              end end end end end)
			when influence = 3 then 
            (case when language='sr-Latn-CS' then 'Visok' else 
             case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else 
			 case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else 
             'High' end end end end end end end end end)
		else '' end
	else '' end as Influence,            	 
	case when priority is not null then
		case 
			when priority = 1 then
            (case when language='sr-Latn-CS' then 'Nizak' else 
             case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else 
			 case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
			 	case when language='es-SE' then 'Bajo' else	
             'Low' end end end end end end end end end)
			when priority = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
             case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else 
			 case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end end end end end
              end)
			when priority = 3 then 
            (case when language='sr-Latn-CS' then 'Visok' else 
             case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else 
			 case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else
             'High' end end end end end end end end end)
		else '' end
	else '' end as priority,          
	case when solveDate is null then 
        (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
         CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
     CASE WHEN language='en-GB' then 'No' else    
	 CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else
	 'No' end end end end end end end end end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
     CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else 
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else
	 'Yes' end end end end end end end end end)
    end as Solved
	
from 
	problem p
where
	p.projectId =  ProjectId
	and p.deactivationDate is null$$

DROP PROCEDURE IF EXISTS `sp_GetProjectReourcesGantt`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectReourcesGantt` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  SELECT DISTINCT `activityresource`.`Id`,`activityresource`.Name
FROM `activityresource` inner join `activity` ON
`activityresource`.ActivityId=`activity`.Id
WHERE `activity`.`ProjectId`=ProjectId and `activityresource`.deactivationDate is null$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResources`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResources`(IN `ProjectId` BIGINT, IN `language` VARCHAR(20))
BEGIN

select 
	r.ResourceName as ResourceName,
	rt.name as ResourceType,
	a.name as Activity
from projectresource as pr
inner join resource as r on r.id = pr.resourceid
	left join activityResource as ar on ar.ProjectResourceId = pr.id
    left join activity as a ON ar.ActivityId = a.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
where
	pr.projectId =  ProjectId 
	and pr.deactivationDate is null
    and rt.LanguageCode=language
	
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResourcesNew`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResourcesNew`(IN `ProjectId` BIGINT, IN `language` VARCHAR(20))
BEGIN

SET @row_number = 0;

select 
(@row_number:=@row_number + 1) AS RedniBroj,
	r.ResourceName as Name,
	rt.name as ResourceType,
	a.name as Activity,
	ar.ResourceDescription,
	sum(ar.Amount) as Amount,
    pr.Cost as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as Cost,
    c.Symbol as Currency
from
	projectresource as pr
inner join resource as r on r.Id = pr.ResourceId
	left join activityResource as ar on ar.ProjectResourceId = pr.id
    left join activity as a ON a.Id = ar.ActivityId
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
    pr.projectId =  ProjectId 
	and pr.deactivationDate is null
    and rt.LanguageCode=language
group by r.ResourceName,
pr.Cost,
	rt.name,
	a.name,
	ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResourcesNewActual`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResourcesNewActual`(IN `ProjectId` BIGINT, IN `language` VARCHAR(20))
BEGIN
select 
(@row_number:=@row_number + 1) AS RedniBroj,
	r.ResourceName as ResourceName,
	rt.name as ResourceType,
	rml.NameLocalized as Value,
    IFNULL(sum(pr.PlanedAmount),0) as PlanedAmount,
	IFNULL(sum(ar.Amount),0) as Amount,
    IFNULL(pr.Cost,0) as JedCijena,
	IFNULL(sum(ar.Cost),0) as ActualCost,
    IFNULL(sum(pr.PlanedAmount * pr.Cost),0) as PlanedCosts,
    c.Symbol as Currency
from
	projectresource as pr
inner join resource as r on r.Id = pr.ResourceId
	left join activityResource as ar on ar.ProjectResourceId = pr.id
    left join activity as a ON a.Id = ar.ActivityId
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	pr.projectId =  ProjectId 
	and pr.deactivationDate is null
    and rt.LanguageCode=language
group by r.ResourceName,
rt.name,
pr.Cost,
c.Symbol
order by @row_number asc
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResourcesNewByActivity`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResourcesNewByActivity` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;

select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as ResourceName,
	rt.name as ResourceType,
	a.name as Activity,
	ar.ResourceDescription,
   	sum(ar.Amount) as Amount,
    ar.UnitPrice as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as Cost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	rt.name,
	a.name,
    ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc
;
END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResourcesNewByActivityGroup`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResourcesNewByActivityGroup` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;

select distinct h1a.Activity,
    h1a.ActivityStartDate,
    h1a.ActivityEndDate,
    h1a.ActivityUsers
    FROM 
(select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as ResourceName,
	rt.name as ResourceType,
	a.name as Activity,
    a.StartDate as ActivityStartDate,
    a.EndDate as ActivityEndDate,
    (SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a.Id
			    GROUP BY a.Id) as ActivityUsers,
	ar.ResourceDescription,
   	sum(ar.Amount) as Amount,
    ar.UnitPrice as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as Cost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	rt.name,
	a.name,
    a.StartDate,
    a.EndDate,
    ActivityUsers,
	ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc
) as h1a;

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectResourcesNewByActivitySum`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectResourcesNewByActivitySum` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  BEGIN

SET @row_number = 0;
Select h1a.Activity,
h1a.Currency,
sum(h1a.Cost) as Cost
from
(select 
(@row_number:=@row_number + 1) AS RedniBroj,
	ar.name as ResourceName,
	rt.name as ResourceType,
	a.name as Activity,
	ar.ResourceDescription,
   	sum(ar.Amount) as Amount,
    ar.UnitPrice as JedCijena,
	rml.NameLocalized as Value,
	sum(ar.Cost) as Cost,
    c.Symbol as Currency
from
	activity as a
	inner join activityResource as ar on ar.activityId = a.id
    inner join projectresource as pr on ar.ProjectResourceId=pr.Id
	inner join resourceTypelocalized as rt on pr.ResourceTypeId = rt.code
    inner join project p on pr.ProjectId=p.Id
    inner join currency c on p.CurrencyId=c.Id
    inner join resourcemesurmentunitlocalized rml on pr.ValueProjectResource=rml.ParentId and rml.LanguageCode=language
where
	a.projectId =  ProjectId 
	and ar.deactivationDate is null
    and rt.LanguageCode=language
group by ar.name,
ar.UnitPrice,
	rt.name,
	a.name,
    ar.ResourceDescription,ar.ValueResource,c.Symbol
order by Activity,@row_number asc
) as h1a
group by h1a.Activity,
h1a.Currency;

END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectRisks`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectRisks` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  SELECT p.RiskName,
		p.IsClosed,
        p.RiskUsers,
        p.RiskActivities,
        p.Influence,
        p.Priority,
        p.Solved
        FROM
(select	r.name as RiskName,
	case when r.IsClosed = 0 then 
     (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
      CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein'  else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else 'No' 
     end
     end
     end
     end
     end 
     end 
     end 
     end 
     end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
	CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else 'Yes' 
     end end end end end end end end end)
 end as IsClosed,
	(SELECT Group_concat(DISTINCT COALESCE(User.name,' ') SEPARATOR ";") 
	FROM User inner join RiskUser ON User.Id=RiskUser.UserId  
	where RiskUser.deactivationDate is null and RiskUser.RiskId=r.Id
	GROUP BY RiskUser.RiskId) as RiskUsers,
	(SELECT Group_concat( DISTINCT COALESCE(activity.name,' ')  SEPARATOR ";")
				FROM activity inner join riskactivity  as b ON
				activity.Id=b.ActivityId
				where  b.deactivationDate is null and r.Id=b.riskId 
				GROUP BY riskId) as RiskActivities,
	case when influence is not null then
		case 
			when influence = 1 then
            (case when language='sr-Latn-CS' then 'Visok' else 
			case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else 
			 case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else 
             'High' end end end end end end end end end)
			when influence = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
			case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else 
			 case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end 
              end end end end end)
			when influence = 3 then 
            (case when language='sr-Latn-CS' then 'Nizak' else 
			case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else 
			 case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
				case when language='es-SE' then 'Bajo' else			 
             'Low' end end end end end end end end end)
		else '' end
	else '' end as Influence,   
	case when priority is not null then
		case 
			when priority = 1 then
            (case when language='sr-Latn-CS' then 'Visok' else 
			case when language='bs-Ba' then 'Visok' else 
             case when language='hr-HR' then 'Visok' else 
             case when language='en-AU' then 'High' else 
             case when language='de-DE' then 'Hoch' else
			 case when language='en-GB' then 'High' else 
             case when language='it-IT' then 'Alto' else 
             case when language='sl-SI' then 'Visoko' else 
			 case when language='es-SE' then 'Alto' else
             'High' end end end end end end end end end)
			when priority = 2 then 
            (case when language='sr-Latn-CS' then 'Srednji' else 
			case when language='bs-Ba' then 'Srednji' else 
             case when language='hr-HR' then 'Srednji' else 
             case when language='en-AU' then 'Medium' else 
             case when language='de-DE' then 'Mittel' else
			 case when language='en-GB' then 'Medium' else
             case when language='it-IT' then 'Medio' else
             case when language='sl-SI' then 'Srednje' else
			 case when language='es-SE' then 'Medio' else 
             'Medium' end end end end end end end end
              end)
			when priority = 3 then 
            (case when language='sr-Latn-CS' then 'Nizak' else 
			case when language='bs-Ba' then 'Nizak' else 
             case when language='hr-HR' then 'Nizak' else 
             case when language='en-AU' then 'Low' else 
             case when language='de-DE' then 'Niedrig' else 
			case when language='en-GB' then 'Low' else
             case when language='it-IT' then 'Basso' else
             case when language='sl-SI' then 'Nizko' else
			 	case when language='es-SE' then 'Bajo' else	
             'Low' end end end end end end end end  end)
		else '' end
	else '' end as Priority,       
	case when solveDate is null then 
     (CASE WHEN language='sr-Latn-CS' then 'Ne' else 
	 CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else
	 'No' end end end end end end end end end)
    else 
    (CASE WHEN language='sr-Latn-CS' then 'Da' else 
	CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else
	 'Yes' end end end end end end end end end)
 end as Solved
from 
	risk r
where
	r.projectId =  ProjectId
	and r.deactivationDate is null) as p$$

DROP PROCEDURE IF EXISTS `sp_GetProjectsOverview`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectsOverview` (IN `categoryId` BIGINT, IN `status` BIGINT, IN `datefrom` DATE, IN `dateTO` DATE, IN `language` VARCHAR(20), IN `applied` BIGINT)  NO SQL
BEGIN
SELECT DISTINCT Project.Name,
                Project.ProjectNumber,
                Project.Id,
                ProjectCategoryLocalized.Name as Category,
                Project.ProjectCategoryId AS CategoryId,
                ProjectStatusLocalized.Name AS Status,
                ProjectStatusLocalized.ParentId AS StatusId,
                Project.StartDate,
                Project.EndDate,
                                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId=2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id)  AS ProjectManager,
                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId <> 2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id) AS TeamMembers,
project.projectPrice,
                c.symbol,
                pa.ProjectAppliedId as Applied
FROM   Project
       LEFT OUTER JOIN
       `User` AS ProjectManager
       ON Project.ManagerId = ProjectManager.Id
       LEFT OUTER JOIN
       ProjectCategoryLocalized
       ON Project.ProjectCategoryId = ProjectCategoryLocalized.ParentId AND ProjectCategoryLocalized.LanguageCode = language
       LEFT OUTER JOIN
       ProjectStatusLocalized
       ON Project.ProjectStatusId = ProjectStatusLocalized.ParentId AND ProjectStatusLocalized.LanguageCode = language
       LEFT OUTER JOIN
       UserProject AS MainUserProject
       ON Project.Id = MainUserProject.ProjectId
       left outer join
       Currency c on c.id = project.currencyId
       LEFT OUTER JOIN projectprojectApplied as pa ON
       Project.Id=pa.ProjectId
WHERE  (Project.startDate >=  dateFrom
        OR  dateFrom IS NULL)
       AND (Project.startDate <=  dateTo
            OR  dateTo IS NULL)
       AND (Project.ProjectCategoryId =  categoryId
            OR  categoryId IS NULL)
            AND (pa.ProjectAppliedId =  applied
            OR  applied IS NULL)
       AND (Project.ProjectStatusId =  status
            OR  status IS NULL)
		AND	(ProjectCategoryLocalized.LanguageCode = language)
		AND	(ProjectStatusLocalized.LanguageCode = language)
	   AND Project.DeactivationDate IS NULL;
       END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectsOverviewNew`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectsOverviewNew` (IN `categoryId` BIGINT, IN `status` BIGINT, IN `datefrom` DATE, IN `dateTO` DATE, IN `language` VARCHAR(20))  NO SQL
BEGIN
SELECT h1.Name,
h1.ProjectNumber,
h1.Id,
h1.Category,
h1.CategoryId,
h1.STATUS,
h1.StatusId,
h1.StartDate,
h1.EndDate,
h1.ProjectManager,
h1.TeamMembers,
IFNULL(h1.projectPrice,0) as projectPrice,
h1.symbol,
IFNULL(h1tu.TimeCosts,0) as TimeCosts,
IFNULL(h1e.ExpPrice,0) as ExpPrice,
IFNULL(h1r.ResourceCosts,0) as ResourceCosts,
IFNULL(h1b.ProjectBudget,0) as ProjectBudget
from
(SELECT DISTINCT Project.Name,
                Project.ProjectNumber,
                Project.Id,
                ProjectCategoryLocalized.Name as Category,
                Project.ProjectCategoryId AS CategoryId,
                ProjectStatusLocalized.Name AS Status,
                ProjectStatusLocalized.ParentId AS StatusId,
                Project.StartDate,
                Project.EndDate,
                                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId=2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id)  AS ProjectManager,
                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId <> 2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id) AS TeamMembers,
project.projectPrice,
                c.symbol
FROM   Project
       LEFT OUTER JOIN
       `User` AS ProjectManager
       ON Project.ManagerId = ProjectManager.Id
       LEFT OUTER JOIN
       ProjectCategoryLocalized
       ON Project.ProjectCategoryId = ProjectCategoryLocalized.ParentId AND ProjectCategoryLocalized.LanguageCode = language
       LEFT OUTER JOIN
       ProjectStatusLocalized
       ON Project.ProjectStatusId = ProjectStatusLocalized.ParentId AND ProjectStatusLocalized.LanguageCode = language
       LEFT OUTER JOIN
       UserProject AS MainUserProject
       ON Project.Id = MainUserProject.ProjectId
       left outer join
       Currency c on c.id = project.currencyId
      
WHERE  (Project.startDate >=  dateFrom
        OR  dateFrom IS NULL)
       AND (Project.startDate <=  dateTo
            OR  dateTo IS NULL)
       AND (Project.ProjectCategoryId =  categoryId
            OR  categoryId IS NULL)
                  AND (Project.ProjectStatusId =  status
            OR  status IS NULL)
		AND	(ProjectCategoryLocalized.LanguageCode = language)
		AND	(ProjectStatusLocalized.LanguageCode = language)
	   AND Project.DeactivationDate IS NULL) as h1
       left outer join 
       (select timeuse.ProjectId as Id,SUM(Amount) as TimeCosts from timeuse  GROUP BY timeuse.ProjectId) as h1tu ON h1.Id = h1tu.Id
       left outer join 
				(select Expense.ProjectId as Id,SUM(Price) as ExpPrice from Expense GROUP BY Expense.ProjectId) as h1e
                ON h1.Id = h1e.Id
      left outer join          
				(select a.ProjectId as Id, SUM(ar.Cost) as ResourceCosts from activity as a 
	   LEFT OUTER JOIN activityresource as ar ON
	   a.Id = ar.ActivityId GROUP BY a.ProjectId ) as h1r
 ON h1.Id = h1r.Id
       left outer join
	   (select projectbudget.ProjectId as Id,SUM(projectbudget.Value) as ProjectBudget from projectbudget
	   GROUP BY projectbudget.ProjectId) as h1b ON
h1.Id = h1b.Id;
       
       END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectsOverviewNewActivity`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectsOverviewNewActivity` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(15))  NO SQL
BEGIN
INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

SELECT 
nomenclature,tabelaakt1.Name as Activity,tabelaakt1.StartDate  as activityStartDate,tabelaakt1.EndDate as activityendDate,tabelaakt1.Progress,
tabelaakt1.ActivityUsers,
ROUND(IFNULL(Sum(tabelaakt1.Price),0),2) as Price,tabelaakt1.Currency,
ROUND(IFNULL(sum(ar.Cost),0),2) as ResourceCost,
ROUND(IFNULL(sum(tu.Amount),0),2) as TimeCosts,
ROUND(IFNULL(sum(ex.Price),0),2) as Troskovi,
ROUND(IFNULL(Sum(tabelaakt1.Price),0) - IFNULL(sum(ar.Cost),0) - IFNULL(sum(tu.Amount),0) - IFNULL(sum(ex.Price),0),2) as razlika,
ROUND(IFNULL(sum(ar.Cost),0) + IFNULL(sum(tu.Amount),0) + IFNULL(sum(ex.Price),0),2) as SumaTroskova
FROM  tabelaakt1 left outer join timeUse tu on tabelaakt1.id = tu.ActivityId
left outer join activityresource ar ON tabelaakt1.id = ar.ActivityId
left outer join expense ex ON tabelaakt1.id = ex.ActivityId
group by 
nomenclature,tabelaakt1.Name,tabelaakt1.StartDate,tabelaakt1.EndDate,tabelaakt1.Progress,
tabelaakt1.ActivityUsers,tabelaakt1.Price,tabelaakt1.Currency
ORDER BY CAST(nomnumb as decimal(18,14));

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId = userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId = userId;
       
       END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectsOverviewNewActivitySum`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectsOverviewNewActivitySum` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20), IN `userId` VARCHAR(15))  NO SQL
BEGIN
INSERT INTO tabelaakt1
SELECT 
		a1.ordinalnumber as nomenclature,
        a1.ordinalnumber as nomnumb,
        1 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;
INSERT INTO tabelaakt2
SELECT 
		a1.ordinalnumber as nomenclature,
        0 as Nivo,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency,
          ProjectId as projectId,
     userId as userId
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null;		
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,'.',a2.nomenclature)  as nomnumb,
        2 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
         a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
          ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=1 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        3 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=2 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;
     
INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        4 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=3 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

INSERT INTO tabelaakt1
SELECT 
		CONCAT(tabelaakt1.nomenclature,'.',a2.nomenclature)  as nomenclature,
        CONCAT(tabelaakt1.nomnumb,a2.nomenclature)  as nomnumb,
        5 as Nivo,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
        a2.ActivityUsers,
	 a2.Price,
	 a2.Currency,
     ProjectId as projectId,
     userId as userId,
     0 as Summary
     FROM tabelaakt2 as a2 inner join tabelaakt1
     ON a2.parentId=tabelaakt1.id and tabelaakt1.Nivo=4 and a2.projectId=tabelaakt1.projectId and a2.userId=tabelaakt1.userId;

SELECT tabelaakt1.Currency,
ROUND(IFNULL(Sum(tabelaakt1.Price),0),2) as Price,
ROUND(IFNULL(sum(ar.Cost),0),2) as ResourceCost,
ROUND(IFNULL(sum(tu.Amount),0),2) as TimeCosts,
ROUND(IFNULL(sum(ex.Price),0),2) as Troskovi,
ROUND(IFNULL(tabelaakt1.Price,0) - IFNULL(sum(ar.Cost),0) - IFNULL(sum(tu.Amount),0) - IFNULL(sum(ex.Price),0),2) as razlika,
ROUND(IFNULL(sum(ar.Cost),0) + IFNULL(sum(tu.Amount),0) + IFNULL(sum(ex.Price),0),2) as SumaTroskova
FROM  tabelaakt1 left outer join timeUse tu on tabelaakt1.id = tu.ActivityId
left outer join activityresource ar ON tabelaakt1.id = ar.ActivityId
left outer join expense ex ON tabelaakt1.id = ex.ActivityId
group by 
tabelaakt1.Currency;

DELETE FROM `tabelaakt1` WHERE tabelaakt1.projectId=ProjectId and tabelaakt1.userId = userId; 
DELETE FROM `tabelaakt2` WHERE tabelaakt2.projectId=ProjectId and tabelaakt2.userId = userId;
       
       END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectsOverviewNewSum`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectsOverviewNewSum` (IN `categoryId` BIGINT, IN `status` BIGINT, IN `datefrom` DATE, IN `dateTO` DATE, IN `language` VARCHAR(20))  NO SQL
BEGIN
SELECT h1.symbol,
IFNULL(Sum(h1.projectPrice),0) as projectPrice,
IFNULL(Sum(h1tu.TimeCosts),0) as TimeCosts,
IFNULL(Sum(h1e.ExpPrice),0) as ExpPrice,
IFNULL(Sum(h1r.ResourceCosts),0) as ResourceCosts,
IFNULL(Sum(h1b.ProjectBudget),0) as ProjectBudget,
IFNULL(Sum(h1r.ResourceCosts),0) + IFNULL(Sum(h1e.ExpPrice),0) + IFNULL(Sum(h1tu.TimeCosts),0) as RealCosts,
IFNULL(Sum(h1.projectPrice),0) - IFNULL(Sum(h1r.ResourceCosts),0) - IFNULL(Sum(h1e.ExpPrice),0) - IFNULL(Sum(h1tu.TimeCosts),0) as UnderOver
from
(SELECT DISTINCT Project.Name,
                Project.ProjectNumber,
                Project.Id,
                ProjectCategoryLocalized.Name as Category,
                Project.ProjectCategoryId AS CategoryId,
                ProjectStatusLocalized.Name AS Status,
                ProjectStatusLocalized.ParentId AS StatusId,
                Project.StartDate,
                Project.EndDate,
                                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId=2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id)  AS ProjectManager,
                (SELECT Group_concat(DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")
                           FROM   `User`
                                  INNER JOIN
                                  UserProject AS PMUP                  
                                  ON User.Id = PMUP.UserId
                               WHERE  PMUP.RoleId <> 2 and Project.Id = PMUP.ProjectId
                GROUP BY Project.Id) AS TeamMembers,
project.projectPrice,
                c.symbol
FROM   Project
       LEFT OUTER JOIN
       `User` AS ProjectManager
       ON Project.ManagerId = ProjectManager.Id
       LEFT OUTER JOIN
       ProjectCategoryLocalized
       ON Project.ProjectCategoryId = ProjectCategoryLocalized.ParentId AND ProjectCategoryLocalized.LanguageCode = language
       LEFT OUTER JOIN
       ProjectStatusLocalized
       ON Project.ProjectStatusId = ProjectStatusLocalized.ParentId AND ProjectStatusLocalized.LanguageCode = language
       LEFT OUTER JOIN
       UserProject AS MainUserProject
       ON Project.Id = MainUserProject.ProjectId
       left outer join
       Currency c on c.id = project.currencyId
      
WHERE  (Project.startDate >=  dateFrom
        OR  dateFrom IS NULL)
       AND (Project.startDate <=  dateTo
            OR  dateTo IS NULL)
       AND (Project.ProjectCategoryId =  categoryId
            OR  categoryId IS NULL)
                  AND (Project.ProjectStatusId =  status
            OR  status IS NULL)
		AND	(ProjectCategoryLocalized.LanguageCode = language)
		AND	(ProjectStatusLocalized.LanguageCode = language)
	   AND Project.DeactivationDate IS NULL) as h1
       left outer join 
       (select timeuse.ProjectId as Id,SUM(Amount) as TimeCosts from timeuse  GROUP BY timeuse.ProjectId) as h1tu ON h1.Id = h1tu.Id
       left outer join 
				(select Expense.ProjectId as Id,SUM(Price) as ExpPrice from Expense GROUP BY Expense.ProjectId) as h1e
                ON h1.Id = h1e.Id
      left outer join          
				(select a.ProjectId as Id, SUM(ar.Cost) as ResourceCosts from activity as a 
	   LEFT OUTER JOIN activityresource as ar ON
	   a.Id = ar.ActivityId GROUP BY a.ProjectId ) as h1r
 ON h1.Id = h1r.Id
       left outer join
	   (select projectbudget.ProjectId as Id,SUM(projectbudget.Value) as ProjectBudget from projectbudget
	   GROUP BY projectbudget.ProjectId) as h1b ON
h1.Id = h1b.Id
group by h1.symbol;
       
       END$$

DROP PROCEDURE IF EXISTS `sp_GetProjectTasks`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectTasks` (IN `ProjectId` BIGINT, IN `language` VARCHAR(20))  SELECT *
FROM (
    SELECT 
		a1.ordinalnumber as nomenclature,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		ParentId IS NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null
UNION ALL
 SELECT 
		CONCAT(c.nomenclature,'.',a2.ordinalnumber)  as nomenclature,
		a2.Name,
		a2.StartDate,
		a2.EndDate,
		a2.Progress,
		a2.id, 
		a2.parentId,
      (SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a2.Id 
			    GROUP BY a2.Id) as ActivityUsers,
	 a2.Price,
	 c2.symbol as Currency
    FROM Activity as a2
    inner join Project as p2 on p2.id = a2.projectId
    inner join currency as c2 on p2.currencyId = c2.id
      INNER JOIN (SELECT 
		a1.ordinalnumber as nomenclature,
		a1.Name,
		a1.StartDate,
		a1.EndDate,
		a1.Progress,
		a1.id, 
		a1.parentId, 
(SELECT Group_concat( DISTINCT COALESCE(User.Name,' ') SEPARATOR ";")  
				FROM User inner join ActivityUser
				ON User.Id=ActivityUser.UserId
				WHERE  ActivityUser.ActivityId = a1.Id
			    GROUP BY  a1.Id) as ActivityUsers,
	 a1.Price,
	 c1.symbol as Currency
    FROM Activity as a1
    inner join Project as p1 on p1.id = a1.projectId
    inner join currency as c1 on p1.currencyId = c1.id
    WHERE 
		a1.ParentId IS NOT NULL 
		and a1.ProjectId =  ProjectId 
		and a1.DeactivationDate is null) as c
        ON a2.ParentId = c.id
    WHERE
    a2.ParentId IS NOT NULL
		and a2.ProjectId =  ProjectId
		and a2.DeactivationDate is null
      and c.id=ProjectId
) as hllss$$

DROP PROCEDURE IF EXISTS `sp_GetProjectTimeUse`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_GetProjectTimeUse` (IN `ProjectId` BIGINT, IN `UserId` BIGINT, IN `language` VARCHAR(20), IN `DateFrom` DATETIME, IN `DateTo` DATETIME, IN `IsPayable` BIT)  BEGIN
SET @row_number = 0;
SELECT (@row_number:=@row_number + 1) as RedniBroj,
hll.Activity,
hll.UserName,
hll.Comment,
hll.Hours,
hll.Minutes,
hll.IsPayable,
hll.Amount,
hll.Currency,
hll.Datum
FROM (
select 
	a.Name as Activity,
	u.Name as UserName,
    tu.Description as Comment,
	COALESCE(tu.Hours,0) as Hours,
	COALESCE(tu.Minutes,0) as Minutes,
	case when ifnull(tu.Payable, 0) = 0 then 
	(case when  language = 'sr-Latn-CS' then 'Ne' else 
     CASE WHEN language='bs-BA' then 'Ne' ELSE
     CASE WHEN language='hr-HR' then 'Ne' else
     CASE WHEN language='en-AU' then 'No' else
     CASE WHEN language='de-DE' then 'Nein' else 
	 CASE WHEN language='en-GB' then 'No' else
     CASE WHEN language='it-IT' then 'No' else
     CASE WHEN language='sl-SI' then 'Ne' else
	 CASE WHEN language='es-SE' then 'No' else
	 'No' end end end end end end end end end) 
    else 
    (case when  language = 'sr-Latn-CS' then 'Da' else 
     CASE WHEN language='bs-BA' then 'Da' ELSE
     CASE WHEN language='hr-HR' then 'Da' else
     CASE WHEN language='en-AU' then 'Yes' else
     CASE WHEN language='de-DE' then 'Ja' else
	 CASE WHEN language='en-GB' then 'Yes' else
     CASE WHEN language='it-IT' then 'Si' else
     CASE WHEN language='sl-SI' then 'Da' else
	 CASE WHEN language='es-SE' then 'Si' else
	 'Yes' end end end end end end end end end) end as IsPayable,
	COALESCE(tu.Amount,0) as Amount,
(select  display from currencylocalized inner join  Project ON currencylocalized.parentid = Project.CurrencyId where Project.Id=ProjectId and currencylocalized.languagecode =  language) as Currency,
    tu.TimeUseDate as Datum
from 
	TimeUse as tu
	inner join User as u on tu.UserId = u.Id
	inner join Activity as a on a.id = tu.ActivityId
where
	tu.DeactivationDate is null
	and tu.ProjectId =  ProjectId
    and (tu.Payable = IsPayable  or IsPayable is null)
    and (tu.TimeUseDate>= datefrom or datefrom is null)
    and (tu.TimeUseDate<= dateto or dateto is null)
    and (tu.UserId=userId or userId is null)
) as hll
;

END$$

DROP PROCEDURE IF EXISTS `upgrade_database`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `upgrade_database` ()  MODIFIES SQL DATA
    DETERMINISTIC
BEGIN
ALTER TABLE `projectresource` ADD `PlanedAmount` DECIMAL(10,2) NOT NULL DEFAULT '0' AFTER `DeactivationDate`;

CREATE TEMPORARY TABLE new_tbl SELECT id,Body, url , concat(url,'&Notified=true') as newUrl, Replace(Body,url,concat(url,'&Notified=true')) as newBody FROM `message` WHERE type = 1;

update message INNER JOIN new_tbl ON message.id = new_tbl.id 
SET message.body = new_tbl.newBody, message.url = new_tbl.newUrl;

END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `activity`
--

DROP TABLE IF EXISTS `activity`;
CREATE TABLE IF NOT EXISTS `activity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(500) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `StartDate` datetime NOT NULL,
  `EndDate` datetime NOT NULL,
  `Duration` varchar(250) DEFAULT NULL,
  `WorkingFund` decimal(18,2) DEFAULT NULL,
  `Price` decimal(18,3) NOT NULL,
  `ParentId` bigint(20) DEFAULT NULL,
  `PriorityId` bigint(20) DEFAULT NULL,
  `Progress` int(11) DEFAULT NULL,
  `EstimatedTimeHours` int(11) DEFAULT NULL,
  `EstimatedTimeMinutes` int(11) DEFAULT NULL,
  `Activated` tinyint(4) NOT NULL DEFAULT 1,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `ProjectId` bigint(20) NOT NULL,
  `CurrencyId` bigint(20) NOT NULL,
  `OrdinalNumber` int(11) DEFAULT NULL,
  `IsClosed` tinyint(4) NOT NULL DEFAULT 0,
  `IsMilestone` tinyint(4) NOT NULL DEFAULT 0,
  `SolveDate` datetime DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `CurrencyId` (`CurrencyId`),
  KEY `ParentId` (`ParentId`),
  KEY `PriorityId` (`PriorityId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activitydocument`
--

DROP TABLE IF EXISTS `activitydocument`;
CREATE TABLE IF NOT EXISTS `activitydocument` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `UploadType` (`UploadType`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activitydocumentnote`
--

DROP TABLE IF EXISTS `activitydocumentnote`;
CREATE TABLE IF NOT EXISTS `activitydocumentnote` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `ContentLength` longtext DEFAULT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activitypreprocess`
--

DROP TABLE IF EXISTS `activitypreprocess`;
CREATE TABLE IF NOT EXISTS `activitypreprocess` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `PreprocessType` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `ReferingActivityId` bigint(20) NOT NULL,
  `NumberOfDays` int(11) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `ReferingActivityId` (`ReferingActivityId`),
  KEY `PreprocessType` (`PreprocessType`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `activityresource`
--

DROP TABLE IF EXISTS `activityresource`;
CREATE TABLE IF NOT EXISTS `activityresource` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(350) NOT NULL,
  `ProjectResourceId` bigint(20) NOT NULL,
  `ResourceDescription` varchar(250) DEFAULT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Allocation` int(11) DEFAULT NULL,
  `Amount` decimal(18,2) DEFAULT NULL,
  `ValueResource` bigint(20) NOT NULL,
  `Cost` decimal(18,2) DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  `UnitPrice` decimal(18,2) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`),
  KEY `FK_ProjectResourceId` (`ProjectResourceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activityupdate`
--

DROP TABLE IF EXISTS `activityupdate`;
CREATE TABLE IF NOT EXISTS `activityupdate` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ActivityUpdate` longtext NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activityuser`
--

DROP TABLE IF EXISTS `activityuser`;
CREATE TABLE IF NOT EXISTS `activityuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ActivityId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `alteration`
--

DROP TABLE IF EXISTS `alteration`;
CREATE TABLE IF NOT EXISTS `alteration` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `Name` varchar(512) NOT NULL,
  `Description` varchar(2048) DEFAULT NULL,
  `IsClosed` tinyint(4) NOT NULL,
  `Informee` varchar(512) DEFAULT NULL,
  `InformationDate` datetime DEFAULT NULL,
  `ResolveUntil` datetime DEFAULT NULL,
  `Influence` bigint(20) NOT NULL,
  `Priority` bigint(20) NOT NULL,
  `SolveDate` datetime DEFAULT NULL,
  `SolveDescription` varchar(2048) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `alterationactivity`
--

DROP TABLE IF EXISTS `alterationactivity`;
CREATE TABLE IF NOT EXISTS `alterationactivity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `AlterationId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `AlterationId` (`AlterationId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `alterationuser`
--

DROP TABLE IF EXISTS `alterationuser`;
CREATE TABLE IF NOT EXISTS `alterationuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `AlterationId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `AlterationId` (`AlterationId`),
  KEY `UserId` (`UserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `alternationdocument`
--

DROP TABLE IF EXISTS `alternationdocument`;
CREATE TABLE IF NOT EXISTS `alternationdocument` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `AlternationId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `AlternationId` (`AlternationId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `alternationdocumentnote`
--

DROP TABLE IF EXISTS `alternationdocumentnote`;
CREATE TABLE IF NOT EXISTS `alternationdocumentnote` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `AlternationUpdateId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `ContentLength` longtext DEFAULT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `AlternationUpdateId` (`AlternationUpdateId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `alternationupdate`
--

DROP TABLE IF EXISTS `alternationupdate`;
CREATE TABLE IF NOT EXISTS `alternationupdate` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `AlternationUpdate` longtext NOT NULL,
  `AlternationId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `AlternationId` (`AlternationId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
CREATE TABLE IF NOT EXISTS `currency` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `Symbol` varchar(5) DEFAULT NULL,
  `Display` varchar(5) DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `Rate` decimal(18,3) NOT NULL DEFAULT 1.000,
  `IsDefault` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` (`Id`, `Code`, `Name`, `Symbol`, `Display`, `CreatedBy`, `DeactivationDate`, `DateCreated`, `Rate`, `IsDefault`) VALUES
(1, 'KM', 'Convertible Mark', 'KM', 'BAM', 1, NULL, '2014-04-11 07:55:40', '1.000', 0),
(2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49', '0.510', 0),
(3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08', '1.000', 1),
(4, 'GBP', 'British Pound', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47', '0.420', 0),
(5, 'RSD', 'Serbian dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05', '59.710', 0),
(6, 'HRK', 'Croatian kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42', '3.920', 0),
(7, 'CAD', 'Canadian dollar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42', '1.000', 0),
(8, 'AUD', 'Australian Dollar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:03:59', '0.885', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currencylocalized`
--

DROP TABLE IF EXISTS `currencylocalized`;
CREATE TABLE IF NOT EXISTS `currencylocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `Symbol` varchar(5) DEFAULT NULL,
  `Display` varchar(5) DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `currencylocalized`
--

INSERT INTO `currencylocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `Symbol`, `Display`, `CreatedBy`, `DeactivationDate`, `DateCreated`) VALUES
(1, 'sr-Latn-RS', 1, 'KM', 'Konvertibilna marka', 'KM', 'KM', 1, NULL, '2014-04-11 07:55:40'),
(2, 'en-US', 1, 'KM', 'Convertible Mark', 'KM', 'BAM', 1, NULL, '2014-04-11 07:55:40'),
(3, 'sr-Latn-RS', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(4, 'en-US', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(5, 'sr-Latn-RS', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(6, 'en-US', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(7, 'sr-Latn-RS', 4, 'GBP', 'Britanska funta', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(8, 'en-US', 4, 'GBP', 'British Pound', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(9, 'sr-Latn-RS', 5, 'RSD', 'Srpski dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(10, 'en-US', 5, 'RSD', 'Serbian dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(11, 'sr-Latn-RS', 6, 'HRK', 'Hrvatska kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(12, 'en-US', 6, 'HRK', 'Croatian kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(13, 'sr-Latn-RS', 7, 'CAD', 'Kanadski dolar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(14, 'en-US', 7, 'CAD', 'Canadian dollar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(15, 'hr-HR', 1, 'KM', 'Konvertibilna marka', 'KM', 'KM', 1, NULL, '2014-04-11 07:55:40'),
(16, 'hr-HR', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(17, 'hr-HR', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(18, 'hr-HR', 4, 'GBP', 'Britanska funta', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(19, 'hr-HR', 5, 'RSD', 'Srpski dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(20, 'hr-HR', 6, 'HRK', 'Hrvatska kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(21, 'hr-HR', 7, 'CAD', 'Kanadski dolar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(22, 'bs-BA', 1, 'KM', 'Konvertibilna marka', 'KM', 'KM', 1, NULL, '2014-04-11 07:55:40'),
(23, 'bs-BA', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(24, 'bs-BA', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(25, 'bs-BA', 4, 'GBP', 'Britanska funta', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(26, 'bs-BA', 5, 'RSD', 'Srpski dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(27, 'bs-BA', 6, 'HRK', 'Hrvatska kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(28, 'bs-BA', 7, 'CAD', 'Kanadski dolar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(29, 'en-AU', 1, 'KM', 'Convertible Mark', 'KM', 'BAM', 1, NULL, '2014-04-11 07:55:40'),
(30, 'en-AU', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(31, 'en-AU', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(32, 'en-AU', 4, 'GBP', 'British Pound', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(33, 'en-AU', 5, 'RSD', 'Serbian dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(34, 'en-AU', 6, 'HRK', 'Croatian kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(35, 'en-AU', 7, 'CAD', 'Canadian dollar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(36, 'de-DE', 1, 'KM', 'Konvertierbare Marke', 'KM', 'KM', 1, NULL, '2014-04-11 07:55:40'),
(37, 'de-DE', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2014-04-11 07:56:49'),
(38, 'de-DE', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2014-04-11 07:58:08'),
(39, 'de-DE', 4, 'GBP', 'Britisches Pfund', '£', 'GBP', 1, NULL, '2014-04-11 07:59:47'),
(40, 'de-DE', 5, 'RSD', 'Serbischer Dinar', 'RSD', 'RSD', 1, NULL, '2014-04-11 08:02:05'),
(41, 'de-DE', 6, 'HRK', 'Kroatische Kuna', 'kn', 'HRK', 1, NULL, '2014-04-11 08:03:42'),
(42, 'de-DE', 7, 'CAD', 'Kanadischer Dollar', 'C$', 'CAD', 1, NULL, '2014-04-11 08:03:42'),
(43, 'sr-Latn-RS', 8, 'AUD', 'Australijski dolar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:21'),
(44, 'en-US', 8, 'AUD', 'Australian Dollar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:22'),
(45, 'en-AU', 8, 'AUD', 'Australian Dollar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:22'),
(46, 'hr-HR', 8, 'AUD', 'Australijski dolar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:22'),
(47, 'bs-BA', 8, 'AUD', 'Australijski dolar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:22'),
(48, 'de-DE', 8, 'AUD', 'Australischer Dollar', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:06:22'),
(49, 'es-ES', 1, 'KM', 'Marca convertible', 'KM', 'BAM', 1, NULL, '2020-04-16 23:24:21'),
(50, 'es-ES', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2020-04-16 23:24:21'),
(51, 'es-ES', 3, 'USD', 'Dólar', '$', 'USD', 1, NULL, '2020-04-16 23:24:21'),
(52, 'es-ES', 4, 'GBP', 'Libra británica', '£', 'GBP', 1, NULL, '2020-04-16 23:24:21'),
(53, 'es-ES', 5, 'RSD', 'Dinar serbio', 'RSD', 'RSD', 1, NULL, '2020-04-16 23:24:21'),
(54, 'es-ES', 6, 'HRK', 'Kuna croata', 'kn', 'HRK', 1, NULL, '2020-04-16 23:24:21'),
(55, 'es-ES', 7, 'CAD', 'Dolar canadiense', 'C$', 'CAD', 1, NULL, '2020-04-16 23:24:21'),
(56, 'es-ES', 8, 'AUD', 'Dólar australiano', 'AU$', 'AU$', 1, NULL, '2020-04-16 23:24:21'),
(57, 'en-GB', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2022-02-01 20:57:25'),
(58, 'en-GB', 3, 'USD', 'Dollar', '$', 'USD', 1, NULL, '2022-02-01 20:57:25'),
(59, 'en-GB', 4, 'GBP', 'British Pound', '£', 'GBP', 1, NULL, '2022-02-01 20:57:25'),
(60, 'en-GB', 5, 'RSD', 'Serbian dinar', 'RSD', 'RSD', 1, NULL, '2022-02-01 20:57:25'),
(61, 'en-GB', 6, 'HRK', 'Croatian kuna', 'kn', 'HRK', 1, NULL, '2022-02-01 20:57:25'),
(62, 'en-GB', 7, 'CAD', 'Canadian dollar', 'C$', 'CAD', 1, NULL, '2022-02-01 20:57:25'),
(63, 'en-GB', 8, 'AUD', 'Australian Dollar', 'AU$', 'AU$', 1, NULL, '2022-02-01 20:57:25'),
(64, 'sl-SI', 2, 'EUR', 'Evro', '€', 'EUR', 1, NULL, '2022-02-01 20:57:25'),
(65, 'sl-SI', 3, 'USD', 'Dolar', '$', 'USD', 1, NULL, '2022-02-01 20:57:25'),
(66, 'sl-SI', 4, 'GBP', 'Britanski funt', '£', 'GBP', 1, NULL, '2022-02-01 20:57:25'),
(67, 'sl-SI', 5, 'RSD', 'Srbski dinar', 'RSD', 'RSD', 1, NULL, '2022-02-01 20:57:25'),
(68, 'sl-SI', 6, 'HRK', 'Hrvaške kune', 'kn', 'HRK', 1, NULL, '2022-02-01 20:57:25'),
(69, 'sl-SI', 7, 'CAD', 'Kanadski dolar', 'C$', 'CAD', 1, NULL, '2022-02-01 20:57:25'),
(70, 'sl-SI', 8, 'AUD', 'Avstralski dolar', 'AU$', 'AU$', 1, NULL, '2022-02-01 20:57:25'),
(71, 'it-IT', 2, 'EUR', 'Euro', '€', 'EUR', 1, NULL, '2022-02-01 20:57:25'),
(72, 'it-IT', 3, 'USD', 'Dollaro', '$', 'USD', 1, NULL, '2022-02-01 20:57:25'),
(73, 'it-IT', 4, 'GBP', 'Sterlina Inglese', '£', 'GBP', 1, NULL, '2022-02-01 20:57:25'),
(74, 'it-IT', 5, 'RSD', 'Dinaro serbo', 'RSD', 'RSD', 1, NULL, '2022-02-01 20:57:25'),
(75, 'it-IT', 6, 'HRK', 'Kuna croata', 'kn', 'HRK', 1, NULL, '2022-02-01 20:57:25'),
(76, 'it-IT', 7, 'CAD', 'Dollaro canadese', 'C$', 'CAD', 1, NULL, '2022-02-01 20:57:25'),
(77, 'it-IT', 8, 'AUD', 'Dollaro australiano', 'AU$', 'AU$', 1, NULL, '2022-02-01 20:57:25');

-- --------------------------------------------------------

--
-- Table structure for table `enuminfluence`
--

DROP TABLE IF EXISTS `enuminfluence`;
CREATE TABLE IF NOT EXISTS `enuminfluence` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enuminfluence`
--

INSERT INTO `enuminfluence` (`Id`, `Name`, `Description`) VALUES
(1, 'Visok', 'Visok uticaj'),
(2, 'Nizak', 'Nizak uticaj'),
(3, 'Srednji', 'Srednji uticaj');

-- --------------------------------------------------------

--
-- Table structure for table `enuminfluencelocalized`
--

DROP TABLE IF EXISTS `enuminfluencelocalized`;
CREATE TABLE IF NOT EXISTS `enuminfluencelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enuminfluencelocalized`
--

INSERT INTO `enuminfluencelocalized` (`Id`, `LanguageCode`, `ParentId`, `Name`, `Description`) VALUES
(1, 'en-US', 1, 'High', 'High influence'),
(2, 'en-US', 2, 'Low', 'Low influence'),
(3, 'en-US', 3, 'Medium', 'Medium influence'),
(4, 'sr-Latn-RS', 1, 'Visok', 'Visok uticaj'),
(5, 'sr-Latn-RS', 2, 'Nizak', 'Nizak uticaj'),
(6, 'sr-Latn-RS', 3, 'Srednji', 'Srednji uticaj'),
(7, 'en-AU', 1, 'High', 'High influence'),
(8, 'en-AU', 2, 'Low', 'Low influence'),
(9, 'en-AU', 3, 'Medium', 'Medium influence'),
(10, 'bs-BA', 1, 'Visok', 'Visok uticaj'),
(11, 'bs-BA', 2, 'Nizak', 'Nizak uticaj'),
(12, 'bs-BA', 3, 'Srednji', 'Srednji uticaj'),
(13, 'hr-HR', 1, 'Visok', 'Visok uticaj'),
(14, 'hr-HR', 2, 'Nizak', 'Nizak uticaj'),
(15, 'hr-HR', 3, 'Srednji', 'Srednji uticaj'),
(16, 'de-DE', 1, 'Hoch', 'Hohe Wirkung'),
(17, 'de-DE', 2, 'Niedrig', 'Geringe Auswirkung'),
(18, 'de-DE', 3, 'Mittel', 'Mittlere Wirkung'),
(19, 'es-ES', 1, 'Alto', 'Alto impacto'),
(20, 'es-ES', 2, 'Bajo', 'Bajo impacto'),
(21, 'es-ES', 3, 'Medio', 'Impacto medio'),
(22, 'en-GB', 1, 'High', 'High influence'),
(23, 'en-GB', 2, 'Low', 'Low influence'),
(24, 'en-GB', 3, 'Medium', 'Medium influence'),
(25, 'sl-SI', 1, 'Visok', 'Visok vpliv'),
(26, 'sl-SI', 2, 'Nizek', 'Nizek vpliv'),
(27, 'sl-SI', 3, 'Srednji', 'Srednji vpliv'),
(28, 'it-IT', 1, 'Alto', 'Alto impatto'),
(29, 'it-IT', 2, 'Basso', 'Basso impatto'),
(30, 'it-IT', 3, 'Medio', 'Medio impatto');

-- --------------------------------------------------------

--
-- Table structure for table `enumpreprocesstype`
--

DROP TABLE IF EXISTS `enumpreprocesstype`;
CREATE TABLE IF NOT EXISTS `enumpreprocesstype` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) NOT NULL,
  `Prefix` varchar(250) NOT NULL,
  `Sufix` varchar(250) NOT NULL,
  `Description` varchar(500) DEFAULT NULL,
  `Name` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumpreprocesstype`
--

INSERT INTO `enumpreprocesstype` (`Id`, `Code`, `Prefix`, `Sufix`, `Description`, `Name`) VALUES
(0, '0', 'kraj', 'početak', 'Ciljna aktivnost ne može početi prije nego se završi izvorna aktivnost (može početi kasnije)', 'kraj2početak'),
(1, '1', 'početak', 'početak', 'Ciljna aktivnost ne može početi prije nego počne iyvorna aktivnost (može početi kasnije)', 'početak2početak'),
(2, '2', 'kraj', 'kraj', 'Ciljna aktivnost ne može završiti prije nego završi izvorna aktivnost (može završiti kasnije)', 'kraj2kraj'),
(3, '3', 'početak', 'kraj', 'Ciljna aktivnost ne može završiti prije nego počne izvorna aktivnost (može početi kasnije)', 'početak2kraj');

-- --------------------------------------------------------

--
-- Table structure for table `enumpreprocesstypelocalized`
--

DROP TABLE IF EXISTS `enumpreprocesstypelocalized`;
CREATE TABLE IF NOT EXISTS `enumpreprocesstypelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) NOT NULL,
  `Prefix` varchar(250) NOT NULL,
  `Sufix` varchar(250) NOT NULL,
  `Description` varchar(500) DEFAULT NULL,
  `Name` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumpreprocesstypelocalized`
--

INSERT INTO `enumpreprocesstypelocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Prefix`, `Sufix`, `Description`, `Name`) VALUES
(1, 'en-US', 0, '0', 'finish', 'start', 'The target task can\'t start before the source task ends (but it may start later)', 'finish_to_start'),
(2, 'en-US', 1, '1', 'start', 'start', 'The target task can\'t start until the source task starts (but it may start later)', 'start_to_start'),
(3, 'en-US', 2, '2', 'finish', 'finish', 'The target task can\'t end before the source task ends (but it may end later)', 'finish_to_finish'),
(4, 'en-US', 3, '3', 'start', 'finish', 'The target task can\'t end before the source task starts (but it may end later)', 'start_to_finish'),
(5, 'en-AU', 0, '0', 'finish', 'start', 'The target task can\'t start before the source task ends (but it may start later)', 'finish_to_start'),
(6, 'en-AU', 1, '1', 'start', 'start', 'The target task can\'t start until the source task starts (but it may start later)', 'start_to_start'),
(7, 'en-AU', 2, '2', 'finish', 'finish', 'The target task can\'t end before the source task ends (but it may end later)', 'finish_to_finish'),
(8, 'en-AU', 3, '3', 'start', 'finish', 'The target task can\'t end before the source task starts (but it may end later)', 'start_to_finish'),
(9, 'bs-BA', 0, '0', 'kraj', 'početak', 'Ciljna aktivnost ne može početi prije nego se završi izvorna aktivnost (može početi kasnije)', 'kraj2početak'),
(10, 'bs-BA', 1, '1', 'početak', 'početak', 'Ciljna aktivnost ne može početi prije nego počne iyvorna aktivnost (može početi kasnije)', 'početak2početak'),
(11, 'bs-BA', 2, '2', 'kraj', 'kraj', 'Ciljna aktivnost ne može završiti prije nego završi izvorna aktivnost (može završiti kasnije)', 'kraj2kraj'),
(12, 'bs-BA', 3, '3', 'početak', 'kraj', 'Ciljna aktivnost ne može završiti prije nego počne izvorna aktivnost (može početi kasnije)', 'početak2kraj'),
(13, 'hr-HR', 0, '0', 'kraj', 'početak', 'Ciljna aktivnost ne može početi prije nego se završi izvorna aktivnost (može početi kasnije)', 'kraj2početak'),
(14, 'hr-HR', 1, '1', 'početak', 'početak', 'Ciljna aktivnost ne može početi prije nego počne iyvorna aktivnost (može početi kasnije)', 'početak2početak'),
(15, 'hr-HR', 2, '2', 'kraj', 'kraj', 'Ciljna aktivnost ne može završiti prije nego završi izvorna aktivnost (može završiti kasnije)', 'kraj2kraj'),
(16, 'hr-HR', 3, '3', 'početak', 'kraj', 'Ciljna aktivnost ne može završiti prije nego počne izvorna aktivnost (može početi kasnije)', 'početak2kraj'),
(17, 'sr-Latn-RS', 0, '0', 'kraj', 'početak', 'Ciljna aktivnost ne može početi prije nego se završi izvorna aktivnost (može početi kasnije)', 'kraj2početak'),
(18, 'sr-Latn-RS', 1, '1', 'početak', 'početak', 'Ciljna aktivnost ne može početi prije nego počne iyvorna aktivnost (može početi kasnije)', 'početak2početak'),
(19, 'sr-Latn-RS', 2, '2', 'kraj', 'kraj', 'Ciljna aktivnost ne može završiti prije nego završi izvorna aktivnost (može završiti kasnije)', 'kraj2kraj'),
(20, 'sr-Latn-RS', 3, '3', 'početak', 'kraj', 'Ciljna aktivnost ne može završiti prije nego počne izvorna aktivnost (može početi kasnije)', 'početak2kraj'),
(21, 'de-DE', 0, '0', 'finish', 'start', 'The target task can\'t start before the source task ends (but it may start later)', 'finish_to_start'),
(22, 'de-DE', 1, '1', 'start', 'start', 'The target task can\'t start until the source task starts (but it may start later)', 'start_to_start'),
(23, 'de-DE', 2, '2', 'finish', 'finish', 'The target task can\'t end before the source task ends (but it may end later)', 'finish_to_finish'),
(24, 'de-DE', 3, '3', 'start', 'finish', 'The target task can\'t end before the source task starts (but it may end later)', 'start_to_finish'),
(25, 'es-ES', 0, '0', 'fin', 'inicio', 'La actividad de destino no puede comenzar antes de que finalice la actividad original (puede comenzar más tarde).', 'final2inicio'),
(26, 'es-ES', 1, '1', 'inicio', 'inicio', 'La actividad de destino no puede comenzar antes de que comience la actividad original (puede comenzar más tarde).', 'inicio2inicio'),
(27, 'es-ES', 2, '2', 'fin', 'fin', 'La actividad de destino no puede finalizar antes de que finalice la actividad original (puede finalizar más tarde).', 'final2final'),
(28, 'es-ES', 3, '3', 'inicio', 'fin', 'La actividad de destino no puede finalizar antes de que comience la actividad original (puede comenzar más tarde).', 'inicio2final'),
(29, 'en-GB', 0, '0', 'finish', 'start', 'The target task can not start before the source task ends (but it may start later).', 'finish2start'),
(30, 'en-GB', 1, '1', 'start', 'start', 'The target task can not start until the source task starts (but it may start later).', 'start2start'),
(31, 'en-GB', 2, '2', 'finish', 'finish', 'The target task can not end before the source task ends (but it may end later).', 'finish2finish'),
(32, 'en-GB', 3, '3', 'start', 'finish', 'The target task can not end before the source task starts (but it may end later).', 'start2finish'),
(33, 'sl-SI', 0, '0', 'konec', 'začetek', 'Ciljna aktivnost se ne more začeti preden se ne zaključi izvorna aktivnost (začne se kasneje).', 'konec2začetek'),
(34, 'sl-SI', 1, '1', 'začetek', 'začetek', 'Ciljna aktivnost se ne more začeti preden se ne začne izvorna aktivnost (začne se kasneje).', 'začetek2začetek'),
(35, 'sl-SI', 2, '2', 'konec', 'konec', 'Ciljna aktivnost se ne more končati preden se ne konča izvorna aktivnost (konča se kasneje).', 'konec2konec'),
(36, 'sl-SI', 3, '3', 'začetek', 'konec', 'Ciljna aktivnost se ne more končati preden se ne začne izvorna aktivnost (začne se kasneje).', 'začetek2konec'),
(37, 'it-IT', 0, '0', 'finire', 'inizio', 'L attività di destinazione non può iniziare prima del termine dell attività di origine (ma potrebbe iniziare in seguito).', 'finire2inizio'),
(38, 'it-IT', 1, '1', 'inizio', 'inizio', 'L attività di destinazione non può essere avviata fino all avvio dell attività di origine (ma potrebbe iniziare in seguito).', 'inizio2inizio'),
(39, 'it-IT', 2, '2', 'finire', 'finire', 'L attività di destinazione non può terminare prima del termine dell attività di origine (ma potrebbe terminare più tardi).', 'finire2finire'),
(40, 'it-IT', 3, '3', 'inizio', 'finire', 'L attività di destinazione non può terminare prima dell inizio dell attività di origine (ma potrebbe terminare più tardi).', 'inizio2finire');

-- --------------------------------------------------------

--
-- Table structure for table `enumpriority`
--

DROP TABLE IF EXISTS `enumpriority`;
CREATE TABLE IF NOT EXISTS `enumpriority` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  `FileName` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumpriority`
--

INSERT INTO `enumpriority` (`Id`, `Name`, `Description`, `FileName`) VALUES
(1, 'High', 'Visok', 'High.png'),
(2, 'Low', 'Nizak', 'Low.png'),
(3, 'Medium', 'Srednji', 'Medium.png');

-- --------------------------------------------------------

--
-- Table structure for table `enumprioritylocalized`
--

DROP TABLE IF EXISTS `enumprioritylocalized`;
CREATE TABLE IF NOT EXISTS `enumprioritylocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  `FileName` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumprioritylocalized`
--

INSERT INTO `enumprioritylocalized` (`Id`, `LanguageCode`, `ParentId`, `Name`, `Description`, `FileName`) VALUES
(1, 'en-US', 1, 'High', 'High', 'High.png'),
(2, 'en-US', 2, 'Low', 'Low', 'Low.png'),
(3, 'en-US', 3, 'Medium', 'Medium', 'Medium.png'),
(4, 'sr-Latn-RS', 1, 'High', 'Visok', 'High.png'),
(5, 'sr-Latn-RS', 2, 'Low', 'Nizak', 'Low.png'),
(6, 'sr-Latn-RS', 3, 'Medium', 'Srednji', 'Medium.png'),
(7, 'en-AU', 1, 'High', 'High', 'High.png'),
(8, 'en-AU', 2, 'Low', 'Low', 'Low.png'),
(9, 'en-AU', 3, 'Medium', 'Medium', 'Medium.png'),
(10, 'bs-BA', 1, 'High', 'Visok', 'High.png'),
(11, 'bs-BA', 2, 'Low', 'Nizak', 'Low.png'),
(12, 'bs-BA', 3, 'Medium', 'Srednji', 'Medium.png'),
(13, 'hr-HR', 1, 'High', 'Visok', 'High.png'),
(14, 'hr-HR', 2, 'Low', 'Nizak', 'Low.png'),
(15, 'hr-HR', 3, 'Medium', 'Srednji', 'Medium.png'),
(16, 'de-DE', 1, 'Hoch', 'Hoch', 'High.png'),
(17, 'de-DE', 2, 'Niedrig', 'Niedrig', 'Low.png'),
(18, 'de-DE', 3, 'Mittel', 'Mittel', 'Medium.png'),
(19, 'es-ES', 1, 'Alto', 'Alto', 'High.png'),
(20, 'es-ES', 2, 'Bajo', 'Bajo', 'Low.png'),
(21, 'es-ES', 3, 'Medio', 'Medio', 'Medium.png'),
(22, 'en-GB', 1, 'High', 'High', 'High.png'),
(23, 'en-GB', 2, 'Low', 'Low', 'Low.png'),
(24, 'en-GB', 3, 'Medium', 'Medium', 'Medium.png'),
(25, 'sl-SI', 1, 'Visok', 'Visok', 'High.png'),
(26, 'sl-SI', 2, 'Nizek', 'Nizek', 'Low.png'),
(27, 'sl-SI', 3, 'Srednji', 'Srednji', 'Medium.png'),
(28, 'it-IT', 1, 'Alto', 'Alto', 'High.png'),
(29, 'it-IT', 2, 'Basso', 'Basso', 'Low.png'),
(30, 'it-IT', 3, 'Medio', 'Medio', 'Medium.png');

-- --------------------------------------------------------

--
-- Table structure for table `enumprobability`
--

DROP TABLE IF EXISTS `enumprobability`;
CREATE TABLE IF NOT EXISTS `enumprobability` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumprobability`
--

INSERT INTO `enumprobability` (`Id`, `Name`, `Description`) VALUES
(1, 'Visoka', 'Visoka verovatnoća'),
(2, 'Niska', 'Niska verovatnoća'),
(3, 'Srednja', 'Srednja verovatnoća');

-- --------------------------------------------------------

--
-- Table structure for table `enumprobabilitylocalized`
--

DROP TABLE IF EXISTS `enumprobabilitylocalized`;
CREATE TABLE IF NOT EXISTS `enumprobabilitylocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `enumprobabilitylocalized`
--

INSERT INTO `enumprobabilitylocalized` (`Id`, `LanguageCode`, `ParentId`, `Name`, `Description`) VALUES
(1, 'en-US', 1, 'High', 'High probability'),
(2, 'en-US', 2, 'Low', 'Low probability'),
(3, 'en-US', 3, 'Medium', 'Medium probability'),
(4, 'sr-Latn-RS', 1, 'Visoka', 'Visoka verovatnoca'),
(5, 'sr-Latn-RS', 2, 'Niska', 'Niska verovatnoca'),
(6, 'sr-Latn-RS', 3, 'Srednja', 'Srednja verovatnoca'),
(7, 'en-AU', 1, 'High', 'High probability'),
(8, 'en-AU', 2, 'Low', 'Low probability'),
(9, 'en-AU', 3, 'Medium', 'Medium probability'),
(10, 'bs-BA', 1, 'Visoka', 'Visoka verovatnoca'),
(11, 'bs-BA', 2, 'Niska', 'Niska verovatnoca'),
(12, 'bs-BA', 3, 'Srednja', 'Srednja verovatnoca'),
(13, 'hr-HR', 1, 'Visoka', 'Visoka verovatnoca'),
(14, 'hr-HR', 2, 'Niska', 'Niska verovatnoca'),
(15, 'hr-HR', 3, 'Srednja', 'Srednja verovatnoca'),
(16, 'de-DE', 1, 'Hoch', 'Hohe Wahrscheinlichkeit'),
(17, 'de-DE', 2, 'Niedrig', 'Geringe Wahrscheinlichkeit'),
(18, 'de-DE', 3, 'Mittel', 'Mittlere Wahrscheinlichkeit'),
(19, 'es-ES', 1, 'Alta', 'Alta probabilidad'),
(20, 'es-ES', 2, 'Baja', 'Baja probabilidad'),
(21, 'es-ES', 3, 'Media', 'Probabilidad media'),
(22, 'en-GB', 1, 'High', 'High probability'),
(23, 'en-GB', 2, 'Low', 'Low probability'),
(24, 'en-GB', 3, 'Medium', 'Medium probability'),
(25, 'sl-SI', 1, 'Visoka', 'Visoka verjetnost'),
(26, 'sl-SI', 2, 'Nizka', 'Nizka verjetnost'),
(27, 'sl-SI', 3, 'Srednja', 'Srednja verjetnost'),
(28, 'it-IT', 1, 'Alta', 'Alta probabilità'),
(29, 'it-IT', 2, 'Bassa', 'Bassa probabilità'),
(30, 'it-IT', 3, 'Media', 'Media probabilità');

-- --------------------------------------------------------

--
-- Table structure for table `enumuploadtype`
--

DROP TABLE IF EXISTS `enumuploadtype`;
CREATE TABLE IF NOT EXISTS `enumuploadtype` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(250) NOT NULL,
  `Description` varchar(550) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `expense`
--

DROP TABLE IF EXISTS `expense`;
CREATE TABLE IF NOT EXISTS `expense` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `Name` varchar(500) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `ExpenseTypeId` bigint(20) DEFAULT NULL,
  `ExpenseDate` datetime DEFAULT NULL,
  `Price` decimal(18,3) DEFAULT NULL,
  `Registered` varchar(500) DEFAULT NULL,
  `IsPlanned` bit(1) DEFAULT NULL,
  `AmortizationTroughProject` tinyint(4) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `ActivityId` bigint(20) DEFAULT NULL,
  `UnitOfMeasure` varchar(50) DEFAULT NULL,
  `Quantity` decimal(18,2) DEFAULT NULL,
  `AlternativeCurrencyId` bigint(20) DEFAULT NULL,
  `TaxPercentage` decimal(18,2) DEFAULT NULL,
  `PriceByUnitOfMeasure` decimal(18,3) DEFAULT NULL,
  `IsAlternativeCurrency` tinyint(4) DEFAULT NULL,
  `PriceByUnitOfMeasureAlternative` decimal(18,3) DEFAULT NULL,
  `TaxAmountAlternative` decimal(18,3) DEFAULT NULL,
  `PriceAlternative` decimal(18,3) DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `AlternativeCurrencyId` (`AlternativeCurrencyId`),
  KEY `ExpenseTypeId` (`ExpenseTypeId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `expenseactivity`
--

DROP TABLE IF EXISTS `expenseactivity`;
CREATE TABLE IF NOT EXISTS `expenseactivity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ExpenseId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `ExpenseId` (`ExpenseId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `expensenote`
--

DROP TABLE IF EXISTS `expensenote`;
CREATE TABLE IF NOT EXISTS `expensenote` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `expensenotelocalized`
--

DROP TABLE IF EXISTS `expensenotelocalized`;
CREATE TABLE IF NOT EXISTS `expensenotelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `expensetype`
--

DROP TABLE IF EXISTS `expensetype`;
CREATE TABLE IF NOT EXISTS `expensetype` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `expensetype`
--

INSERT INTO `expensetype` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'Personnel expenses', '2014-04-11 08:04:27', 1, NULL),
(2, '2', 'Travel and accommodation', '2014-04-11 08:04:40', 1, NULL),
(3, '3', 'Overhead costs', '2014-04-11 08:04:58', 1, NULL),
(4, '4', 'Consultants', '2014-04-11 08:05:14', 1, NULL),
(5, '5', 'Sastanci i događaji', '2014-04-11 08:05:25', 1, NULL),
(6, '6', 'Promotion costs', '2014-04-11 08:05:37', 1, NULL),
(7, '7', 'Equipment', '2014-04-11 08:05:49', 1, NULL),
(8, '8', 'Financial expenses', '2014-04-11 08:06:00', 1, NULL),
(9, '9', 'Other expenses', '2014-04-11 08:06:17', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `expensetypelocalized`
--

DROP TABLE IF EXISTS `expensetypelocalized`;
CREATE TABLE IF NOT EXISTS `expensetypelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `expensetypelocalized`
--

INSERT INTO `expensetypelocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Troškovi osoblja', '2014-04-11 08:04:27', 1, NULL),
(2, 'en-US', 1, '1', 'Personnel expenses', '2014-04-11 08:04:27', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'Putovanje i smještaj', '2014-04-11 08:04:40', 1, NULL),
(4, 'en-US', 2, '2', 'Travel and accommodation', '2014-04-11 08:04:40', 1, NULL),
(5, 'sr-Latn-RS', 3, '3', 'Režijski troškovi', '2014-04-11 08:04:58', 1, NULL),
(6, 'en-US', 3, '3', 'Overhead costs', '2014-04-11 08:04:58', 1, NULL),
(7, 'sr-Latn-RS', 4, '4', 'Konsultanti', '2014-04-11 08:05:14', 1, NULL),
(8, 'en-US', 4, '4', 'Consultants', '2014-04-11 08:05:14', 1, NULL),
(9, 'sr-Latn-RS', 5, '5', 'Sastanci i događaji', '2014-04-11 08:05:25', 1, NULL),
(10, 'en-US', 5, '5', 'Meetings and events', '2014-04-11 08:05:25', 1, NULL),
(11, 'sr-Latn-RS', 6, '6', 'Troškovi promocije', '2014-04-11 08:05:37', 1, NULL),
(12, 'en-US', 6, '6', 'Promotion costs', '2014-04-11 08:05:37', 1, NULL),
(13, 'sr-Latn-RS', 7, '7', 'Oprema', '2014-04-11 08:05:49', 1, NULL),
(14, 'en-US', 7, '7', 'Equipment', '2014-04-11 08:05:49', 1, NULL),
(15, 'sr-Latn-RS', 8, '8', 'Finansijski troškovi', '2014-04-11 08:06:00', 1, NULL),
(16, 'en-US', 8, '8', 'Financial expenses', '2014-04-11 08:06:00', 1, NULL),
(17, 'sr-Latn-RS', 9, '9', 'Ostali troškovi', '2014-04-11 08:06:18', 1, NULL),
(18, 'en-US', 9, '9', 'Other expenses', '2014-04-11 08:06:18', 1, NULL),
(19, 'en-AU', 1, '1', 'Personnel expenses', '2014-04-11 08:04:27', 1, NULL),
(20, 'en-AU', 2, '2', 'Travel and accommodation', '2014-04-11 08:04:40', 1, NULL),
(21, 'en-AU', 3, '3', 'Overhead costs', '2014-04-11 08:04:58', 1, NULL),
(22, 'en-AU', 4, '4', 'Consultants', '2014-04-11 08:05:14', 1, NULL),
(23, 'en-AU', 5, '5', 'Meetings and events', '2014-04-11 08:05:25', 1, NULL),
(24, 'en-AU', 6, '6', 'Promotion costs', '2014-04-11 08:05:37', 1, NULL),
(25, 'en-AU', 7, '7', 'Equipment', '2014-04-11 08:05:49', 1, NULL),
(26, 'en-AU', 8, '8', 'Financial expenses', '2014-04-11 08:06:00', 1, NULL),
(27, 'en-AU', 9, '9', 'Other expenses', '2014-04-11 08:06:18', 1, NULL),
(34, 'bs-BA', 1, '1', 'Troškovi osoblja', '2014-04-11 08:04:27', 1, NULL),
(35, 'bs-BA', 2, '2', 'Putovanje i smještaj', '2014-04-11 08:04:40', 1, NULL),
(36, 'bs-BA', 3, '3', 'Režijski troškovi', '2014-04-11 08:04:58', 1, NULL),
(37, 'bs-BA', 4, '4', 'Konsultanti', '2014-04-11 08:05:14', 1, NULL),
(38, 'bs-BA', 5, '5', 'Sastanci i događaji', '2014-04-11 08:05:25', 1, NULL),
(39, 'bs-BA', 6, '6', 'Troškovi promocije', '2014-04-11 08:05:37', 1, NULL),
(40, 'bs-BA', 7, '7', 'Oprema', '2014-04-11 08:05:49', 1, NULL),
(41, 'bs-BA', 8, '8', 'Finansijski troškovi', '2014-04-11 08:06:00', 1, NULL),
(42, 'bs-BA', 9, '9', 'Ostali troškovi', '2014-04-11 08:06:18', 1, NULL),
(49, 'hr-HR', 1, '1', 'Troškovi osoblja', '2014-04-11 08:04:27', 1, NULL),
(50, 'hr-HR', 2, '2', 'Putovanje i smještaj', '2014-04-11 08:04:40', 1, NULL),
(51, 'hr-HR', 3, '3', 'Režijski troškovi', '2014-04-11 08:04:58', 1, NULL),
(52, 'hr-HR', 4, '4', 'Konsultanti', '2014-04-11 08:05:14', 1, NULL),
(53, 'hr-HR', 5, '5', 'Sastanci i događaji', '2014-04-11 08:05:25', 1, NULL),
(54, 'hr-HR', 6, '6', 'Troškovi promocije', '2014-04-11 08:05:37', 1, NULL),
(55, 'hr-HR', 7, '7', 'Oprema', '2014-04-11 08:05:49', 1, NULL),
(56, 'hr-HR', 8, '8', 'Finansijski troškovi', '2014-04-11 08:06:00', 1, NULL),
(57, 'hr-HR', 9, '9', 'Ostali troškovi', '2014-04-11 08:06:18', 1, NULL),
(64, 'de-DE', 1, '1', 'Personalkosten', '2014-04-11 08:04:27', 1, NULL),
(65, 'de-DE', 2, '2', 'Reise und Unterkunft', '2014-04-11 08:04:40', 1, NULL),
(66, 'de-DE', 3, '3', 'Gemeinkosten', '2014-04-11 08:04:58', 1, NULL),
(67, 'de-DE', 4, '4', 'Berater', '2014-04-11 08:05:14', 1, NULL),
(68, 'de-DE', 5, '5', 'Meetings und Veranstaltungen', '2014-04-11 08:05:25', 1, NULL),
(69, 'de-DE', 6, '6', 'Werbekosten', '2014-04-11 08:05:37', 1, NULL),
(70, 'de-DE', 7, '7', 'Ausrüstung', '2014-04-11 08:05:49', 1, NULL),
(71, 'de-DE', 8, '8', 'Finanzielle Auslagen', '2014-04-11 08:06:00', 1, NULL),
(72, 'de-DE', 9, '9', 'Andere Ausgaben', '2014-04-11 08:06:18', 1, NULL),
(73, 'es-ES', 1, '1', 'Gastos de personal', '2020-04-16 23:25:35', 1, NULL),
(74, 'es-ES', 2, '2', 'Viaje y alojamiento', '2020-04-16 23:25:35', 1, NULL),
(75, 'es-ES', 3, '3', 'Gastos generales', '2020-04-16 23:25:35', 1, NULL),
(76, 'es-ES', 4, '4', 'Consultores', '2020-04-16 23:25:35', 1, NULL),
(77, 'es-ES', 5, '5', 'Reuniones y eventos', '2020-04-16 23:25:35', 1, NULL),
(78, 'es-ES', 6, '6', 'Costos de promoción', '2020-04-16 23:25:35', 1, NULL),
(79, 'es-ES', 7, '7', 'Equipo', '2020-04-16 23:25:36', 1, NULL),
(80, 'es-ES', 8, '8', 'Gastos financieros', '2020-04-16 23:25:36', 1, NULL),
(81, 'es-ES', 9, '9', 'Otros gastos', '2020-04-16 23:25:36', 1, NULL),
(82, 'en-GB', 1, '1', 'Personnel expenses', '2022-02-01 20:57:25', 1, NULL),
(83, 'en-GB', 2, '2', 'Travel and accommodation', '2022-02-01 20:57:25', 1, NULL),
(84, 'en-GB', 3, '3', 'Overhead costs', '2022-02-01 20:57:25', 1, NULL),
(85, 'en-GB', 4, '4', 'Consultants', '2022-02-01 20:57:25', 1, NULL),
(86, 'en-GB', 5, '5', 'Meetings and events', '2022-02-01 20:57:25', 1, NULL),
(87, 'en-GB', 6, '6', 'Promotion costs', '2022-02-01 20:57:25', 1, NULL),
(88, 'en-GB', 7, '7', 'Equipment', '2022-02-01 20:57:25', 1, NULL),
(89, 'en-GB', 8, '8', 'Financial expenses', '2022-02-01 20:57:25', 1, NULL),
(90, 'en-GB', 9, '9', 'Other expenses', '2022-02-01 20:57:25', 1, NULL),
(91, 'sl-SI', 1, '1', 'Stroški oseblja', '2022-02-01 20:57:26', 1, NULL),
(92, 'sl-SI', 2, '2', 'Potovanja in namestitev', '2022-02-01 20:57:26', 1, NULL),
(93, 'sl-SI', 3, '3', 'Režijski stroški', '2022-02-01 20:57:26', 1, NULL),
(94, 'sl-SI', 4, '4', 'Konzultanti', '2022-02-01 20:57:26', 1, NULL),
(95, 'sl-SI', 5, '5', 'Sestanki in dogodki', '2022-02-01 20:57:26', 1, NULL),
(96, 'sl-SI', 6, '6', 'Stroški promocije', '2022-02-01 20:57:26', 1, NULL),
(97, 'sl-SI', 7, '7', 'Oprema', '2022-02-01 20:57:26', 1, NULL),
(98, 'sl-SI', 8, '8', 'Finančni stroški', '2022-02-01 20:57:26', 1, NULL),
(99, 'sl-SI', 9, '9', 'Ostali stroški', '2022-02-01 20:57:26', 1, NULL),
(100, 'it-IT', 1, '1', 'Costi di personale', '2022-02-01 20:57:26', 1, NULL),
(101, 'it-IT', 2, '2', 'Viaggio e alloggio', '2022-02-01 20:57:26', 1, NULL),
(102, 'it-IT', 3, '3', 'Spese generali', '2022-02-01 20:57:26', 1, NULL),
(103, 'it-IT', 4, '4', 'Consulenti', '2022-02-01 20:57:26', 1, NULL),
(104, 'it-IT', 5, '5', 'Incontri e eventi', '2022-02-01 20:57:26', 1, NULL),
(105, 'it-IT', 6, '6', 'Costi di promozione', '2022-02-01 20:57:26', 1, NULL),
(106, 'it-IT', 7, '7', 'Attrezzatura', '2022-02-01 20:57:26', 1, NULL),
(107, 'it-IT', 8, '8', 'Costi finanziari', '2022-02-01 20:57:26', 1, NULL),
(108, 'it-IT', 9, '9', 'Altri costi', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `institutiontype`
--

DROP TABLE IF EXISTS `institutiontype`;
CREATE TABLE IF NOT EXISTS `institutiontype` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `institutiontype`
--

INSERT INTO `institutiontype` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'Municipality', '2014-04-11 08:07:26', 1, NULL),
(2, '2', 'NGO', '2014-04-11 08:07:43', 1, NULL),
(3, '3', 'Government', '2014-04-11 08:07:59', 1, NULL),
(4, '4', 'Company', '2014-04-11 08:08:15', 1, NULL),
(5, '5', 'Agency', '2014-04-11 08:08:34', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `institutiontypelocalized`
--

DROP TABLE IF EXISTS `institutiontypelocalized`;
CREATE TABLE IF NOT EXISTS `institutiontypelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `institutiontypelocalized`
--

INSERT INTO `institutiontypelocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Opstina', '2014-04-11 08:07:26', 1, NULL),
(2, 'en-US', 1, '1', 'Municipality', '2014-04-11 08:07:26', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'NVO', '2014-04-11 08:07:43', 1, NULL),
(4, 'en-US', 2, '2', 'NGO', '2014-04-11 08:07:43', 1, NULL),
(5, 'sr-Latn-RS', 3, '3', 'Vlada', '2014-04-11 08:07:59', 1, NULL),
(6, 'en-US', 3, '3', 'Government', '2014-04-11 08:07:59', 1, NULL),
(7, 'sr-Latn-RS', 4, '4', 'Kompanija', '2014-04-11 08:08:16', 1, NULL),
(8, 'en-US', 4, '4', 'Company', '2014-04-11 08:08:16', 1, NULL),
(9, 'sr-Latn-RS', 5, '5', 'Agencija', '2014-04-11 08:08:34', 1, NULL),
(10, 'en-US', 5, '5', 'Agency', '2014-04-11 08:08:34', 1, NULL),
(11, 'en-AU', 1, '1', 'Municipality', '2014-04-11 08:07:26', 1, NULL),
(12, 'en-AU', 2, '2', 'NGO', '2014-04-11 08:07:43', 1, NULL),
(13, 'en-AU', 3, '3', 'Government', '2014-04-11 08:07:59', 1, NULL),
(14, 'en-AU', 4, '4', 'Company', '2014-04-11 08:08:16', 1, NULL),
(15, 'en-AU', 5, '5', 'Agency', '2014-04-11 08:08:34', 1, NULL),
(18, 'bs-BA', 1, '1', 'Opstina', '2014-04-11 08:07:26', 1, NULL),
(19, 'bs-BA', 2, '2', 'NVO', '2014-04-11 08:07:43', 1, NULL),
(20, 'bs-BA', 3, '3', 'Vlada', '2014-04-11 08:07:59', 1, NULL),
(21, 'bs-BA', 4, '4', 'Kompanija', '2014-04-11 08:08:16', 1, NULL),
(22, 'bs-BA', 5, '5', 'Agencija', '2014-04-11 08:08:34', 1, NULL),
(25, 'hr-HR', 1, '1', 'Opstina', '2014-04-11 08:07:26', 1, NULL),
(26, 'hr-HR', 2, '2', 'NVO', '2014-04-11 08:07:43', 1, NULL),
(27, 'hr-HR', 3, '3', 'Vlada', '2014-04-11 08:07:59', 1, NULL),
(28, 'hr-HR', 4, '4', 'Kompanija', '2014-04-11 08:08:16', 1, NULL),
(29, 'hr-HR', 5, '5', 'Agencija', '2014-04-11 08:08:34', 1, NULL),
(32, 'de-DE', 1, '1', 'Gemeinde', '2014-04-11 08:07:26', 1, NULL),
(33, 'de-DE', 2, '2', 'NGO/NRO', '2014-04-11 08:07:43', 1, NULL),
(34, 'de-DE', 3, '3', 'Regierung', '2014-04-11 08:07:59', 1, NULL),
(35, 'de-DE', 4, '4', 'Unternehmen', '2014-04-11 08:08:16', 1, NULL),
(36, 'de-DE', 5, '5', 'Agentur', '2014-04-11 08:08:34', 1, NULL),
(37, 'es-ES', 1, '1', 'Municipio', '2020-04-16 23:25:36', 1, NULL),
(38, 'es-ES', 2, '2', 'ONG', '2020-04-16 23:25:37', 1, NULL),
(39, 'es-ES', 3, '3', 'Gobierno', '2020-04-16 23:25:37', 1, NULL),
(40, 'es-ES', 4, '4', 'Empresa', '2020-04-16 23:25:37', 1, NULL),
(41, 'es-ES', 5, '5', 'Agencia', '2020-04-16 23:25:37', 1, NULL),
(42, 'en-GB', 1, '1', 'Municipality', '2022-02-01 20:57:25', 1, NULL),
(43, 'en-GB', 2, '2', 'NGO', '2022-02-01 20:57:25', 1, NULL),
(44, 'en-GB', 3, '3', 'Government', '2022-02-01 20:57:25', 1, NULL),
(45, 'en-GB', 4, '4', 'Company', '2022-02-01 20:57:25', 1, NULL),
(46, 'en-GB', 5, '5', 'Agency', '2022-02-01 20:57:25', 1, NULL),
(47, 'en-UK', 1, '1', 'Občina', '2022-02-01 20:57:26', 1, NULL),
(48, 'en-UK', 2, '2', 'NVO', '2022-02-01 20:57:26', 1, NULL),
(49, 'en-UK', 3, '3', 'Vlada', '2022-02-01 20:57:26', 1, NULL),
(50, 'en-UK', 4, '4', 'Podjetje', '2022-02-01 20:57:26', 1, NULL),
(51, 'en-UK', 5, '5', 'Agencija', '2022-02-01 20:57:26', 1, NULL),
(52, 'it-IT', 1, '1', 'Comune', '2022-02-01 20:57:26', 1, NULL),
(53, 'it-IT', 2, '2', 'NVO', '2022-02-01 20:57:26', 1, NULL),
(54, 'it-IT', 3, '3', 'Governo', '2022-02-01 20:57:26', 1, NULL),
(55, 'it-IT', 4, '4', 'Società', '2022-02-01 20:57:26', 1, NULL),
(56, 'it-IT', 5, '5', 'Agenzia', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `kanbancolor`
--

DROP TABLE IF EXISTS `kanbancolor`;
CREATE TABLE IF NOT EXISTS `kanbancolor` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) NOT NULL,
  `Code` char(7) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanbancolor`
--

INSERT INTO `kanbancolor` (`Id`, `Name`, `Code`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'Coral', '#ff7f50', '2019-01-26', 1, NULL),
(2, 'Crimson', '#dc143c', '2019-01-26', 1, NULL),
(3, 'Goldenrod', '#daa520', '2019-01-26', 1, NULL),
(4, 'DeepSkyBlue', '#00bfff', '2019-01-26', 1, NULL),
(5, 'Orchid', '#da70d6', '2019-01-26', 1, NULL),
(6, 'LimeGreen', '#32cd32', '2019-01-26', 1, NULL),
(7, 'Maroon', '#800000', '2019-01-26', 1, NULL),
(8, 'Yellow', '#ffd700', '2019-01-26', 1, NULL),
(9, 'Light red', '#ed6b75', '2019-01-28', 1, NULL),
(10, 'Light Yellow', '#F1C40F', '2019-01-28', 1, NULL),
(11, 'Light Green', '#45a51c', '2019-01-28', 1, NULL),
(12, 'Light Blue', '#659be0', '2019-01-28', 1, NULL),
(13, 'Turquoise', '#00FFFF', '2019-05-31', 1, NULL),
(14, 'Pink', '#FF00FF', '2019-05-31', 1, NULL),
(15, 'Blue', '#0000FF', '2019-05-31', 1, NULL),
(16, 'Red', '#FF0000', '2019-05-31', 1, NULL),
(17, 'Dark Blue', '#000080', '2019-05-31', 1, NULL),
(18, 'Teal', '#008080', '2019-05-31', 1, NULL),
(19, 'Green', '#008000', '2019-05-31', 1, NULL),
(20, 'Golden Brown', '#996600', '2019-05-31', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `kanbancolumn`
--

DROP TABLE IF EXISTS `kanbancolumn`;
CREATE TABLE IF NOT EXISTS `kanbancolumn` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) NOT NULL,
  `Description` varchar(50) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  `ColumnColor` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanbancolumn`
--

INSERT INTO `kanbancolumn` (`Id`, `Name`, `Description`, `DateCreated`, `CreatedBy`, `DeactivationDate`, `ColumnColor`) VALUES
(1, 'ToDo', 'To Do', '2019-01-29', 1, NULL, 1),
(2, 'InProgress', 'In Progress', '2019-01-29', 1, NULL, 3),
(3, 'Done', 'Done', '2019-01-29', 1, NULL, 4);

-- --------------------------------------------------------

--
-- Table structure for table `kanbancolumnslocalized`
--

DROP TABLE IF EXISTS `kanbancolumnslocalized`;
CREATE TABLE IF NOT EXISTS `kanbancolumnslocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Name` varchar(20) NOT NULL,
  `Description` varchar(50) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `kanbancolumnslocalized_ibfk_1` (`ParentId`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `kanbancolumnslocalized`
--

INSERT INTO `kanbancolumnslocalized` (`Id`, `LanguageCode`, `ParentId`, `Name`, `Description`) VALUES
(1, 'sr-Latn-RS', 1, 'ToDo', 'Za uraditi'),
(2, 'en-US', 1, 'ToDo', 'To Do'),
(3, 'en-AU', 1, 'ToDo', 'To Do'),
(4, 'de-DE', 1, 'ToDo', 'Machen'),
(5, 'hr-HR', 1, 'ToDo', 'Za uraditi'),
(6, 'bs-BA', 1, 'ToDo', 'Za uraditi'),
(7, 'sr-Latn-RS', 2, 'InProgress', 'U toku'),
(8, 'en-US', 2, 'InProgress', 'In Progress'),
(9, 'en-AU', 2, 'InProgress', 'In Progress'),
(10, 'de-DE', 2, 'InProgress', 'In Bearbeitung'),
(11, 'hr-HR', 2, 'InProgress', 'U toku'),
(12, 'bs-BA', 2, 'InProgress', 'U toku'),
(13, 'sr-Latn-RS', 3, 'Done', 'Urađeno'),
(14, 'en-US', 3, 'Done', 'Done'),
(15, 'en-AU', 3, 'Done', 'Done'),
(16, 'de-DE', 3, 'Done', 'Erledigt'),
(17, 'hr-HR', 3, 'Done', 'Urađeno'),
(18, 'bs-BA', 3, 'Done', 'Urađeno'),
(19, 'es-ES', 1, 'ToDo', 'Que hacer'),
(20, 'es-ES', 2, 'InProgress', 'En progreso'),
(21, 'es-ES', 3, 'Done', 'Hecho'),
(22, 'en-GB', 1, 'ToDo', 'To Do'),
(23, 'en-GB', 2, 'InProgress', 'In Progress'),
(24, 'en-GB', 3, 'Done', 'Done'),
(25, 'en-UK', 1, 'ToDo', 'Za narediti'),
(26, 'en-UK', 2, 'InProgress', 'V izdelavi'),
(27, 'en-UK', 3, 'Done', 'Narejeno'),
(28, 'it-IT', 1, 'ToDo', 'Da fare'),
(29, 'it-IT', 2, 'InProgress', 'In corso'),
(30, 'it-IT', 3, 'Done', 'Completato');

-- --------------------------------------------------------

--
-- Table structure for table `kanbanprojectactivity`
--

DROP TABLE IF EXISTS `kanbanprojectactivity`;
CREATE TABLE IF NOT EXISTS `kanbanprojectactivity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `ColumnId` bigint(20) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` int(11) NOT NULL,
  `LastUpdatedDate` date NOT NULL,
  `LastUpdatedBy` int(11) NOT NULL,
  `OrdinalNumber` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kanbanprojectsetting`
--

DROP TABLE IF EXISTS `kanbanprojectsetting`;
CREATE TABLE IF NOT EXISTS `kanbanprojectsetting` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ColumnId` bigint(20) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  `ColumnColor` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kanbanuserprojectsetting`
--

DROP TABLE IF EXISTS `kanbanuserprojectsetting`;
CREATE TABLE IF NOT EXISTS `kanbanuserprojectsetting` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ColumnId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  `ColumnColor` bigint(20) NOT NULL,
  `Hide` bit(1) NOT NULL DEFAULT b'0',
  `OrdinalNumber` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

DROP TABLE IF EXISTS `language`;
CREATE TABLE IF NOT EXISTS `language` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) NOT NULL,
  `Code` varchar(20) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `language`
--

INSERT INTO `language` (`Id`, `Name`, `Code`) VALUES
(1, 'Srpski(lat)', 'sr-Latn-RS'),
(2, 'English', 'en-US'),
(3, 'English (Australian)', 'en-AU'),
(4, 'Germans', 'de-DE'),
(5, 'Croatian', 'hr-HR'),
(6, 'Bosnian', 'bs-BA'),
(7, 'Espanol', 'es-ES'),
(8, 'English (UK)', 'en-GB'),
(9, 'Slovenian', 'sl-SI'),
(10, 'Italian', 'it-IT');

-- --------------------------------------------------------

--
-- Table structure for table `logframe`
--

DROP TABLE IF EXISTS `logframe`;
CREATE TABLE IF NOT EXISTS `logframe` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `CommonGoalTitle` longtext DEFAULT NULL,
  `CommonGoalIndicators` longtext DEFAULT NULL,
  `CommonGoalVerificationSource` longtext DEFAULT NULL,
  `CommonGoalAssumptions` longtext DEFAULT NULL,
  `SpecificGoalTitle` longtext DEFAULT NULL,
  `SpecificGoalIndicators` longtext DEFAULT NULL,
  `SpecificGoalVerificationSource` longtext DEFAULT NULL,
  `SpecificGoalAssumptions` longtext DEFAULT NULL,
  `ResultTitle` longtext DEFAULT NULL,
  `ResultIndicators` longtext DEFAULT NULL,
  `ResultVerificationSource` longtext DEFAULT NULL,
  `ResultAssumptions` longtext DEFAULT NULL,
  `ActivityTitle` longtext DEFAULT NULL,
  `ActivityIndicators` longtext DEFAULT NULL,
  `ActivityVerificationSource` longtext DEFAULT NULL,
  `ActivityAssumptions` longtext DEFAULT NULL,
  `Version` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `IsLastVersion` tinyint(4) DEFAULT NULL,
  `Assumptions` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `message`
--

DROP TABLE IF EXISTS `message`;
CREATE TABLE IF NOT EXISTS `message` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Type` int(11) DEFAULT NULL,
  `ProjectId` bigint(20) NOT NULL,
  `Body` longtext DEFAULT NULL,
  `Title` varchar(1024) NOT NULL,
  `Url` varchar(2048) DEFAULT NULL,
  `Comment` longtext DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Folder` tinyint(4) DEFAULT NULL,
  `DateSentReceived` datetime DEFAULT NULL,
  `MessagePriority` int(11) NOT NULL DEFAULT 2,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `messageuser`
--

DROP TABLE IF EXISTS `messageuser`;
CREATE TABLE IF NOT EXISTS `messageuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `MessageId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `IsRead` tinyint(4) NOT NULL,
  `IsReplayed` tinyint(4) DEFAULT NULL,
  `IsForwarded` tinyint(4) DEFAULT NULL,
  `IsDeleted` tinyint(4) DEFAULT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `MessageId` (`MessageId`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `milestone`
--

DROP TABLE IF EXISTS `milestone`;
CREATE TABLE IF NOT EXISTS `milestone` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) DEFAULT NULL,
  `Name` varchar(512) NOT NULL,
  `Description` varchar(2048) DEFAULT NULL,
  `IsClosed` bit(1) NOT NULL,
  `StartDate` datetime NOT NULL,
  `EndDate` datetime DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `milestoneuser`
--

DROP TABLE IF EXISTS `milestoneuser`;
CREATE TABLE IF NOT EXISTS `milestoneuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `MilestoneId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `MilestoneId` (`MilestoneId`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `organizationunit`
--

DROP TABLE IF EXISTS `organizationunit`;
CREATE TABLE IF NOT EXISTS `organizationunit` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `InstitutionTypeId` bigint(20) NOT NULL,
  `Address` varchar(500) DEFAULT NULL,
  `ContactPersonName` varchar(500) DEFAULT NULL,
  `TelephoneNumber` varchar(50) DEFAULT NULL,
  `Email` varchar(500) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `EndDate` datetime DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `InstitutionTypeId` (`InstitutionTypeId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `organizationunitlocalized`
--

DROP TABLE IF EXISTS `organizationunitlocalized`;
CREATE TABLE IF NOT EXISTS `organizationunitlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `Address` varchar(500) DEFAULT NULL,
  `TelephoneNumber` varchar(50) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `permission`
--

DROP TABLE IF EXISTS `permission`;
CREATE TABLE IF NOT EXISTS `permission` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(250) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `DateCreated` datetime DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `permission`
--

INSERT INTO `permission` (`Id`, `Name`, `Description`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'ActivityDelete', 'Aktivnosti - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(2, 'ActivityDocumentDelete', 'Aktivnost – Dokumenti - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(3, 'ActivityDocumentNew', 'Aktivnost – Dokumenti - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(4, 'ActivityDocumentView', 'Aktivnost – Dokumenti - Pregled', '2012-01-01 00:00:00', 1, NULL),
(5, 'ActivityEdit', 'Aktivnosti - Izmena', '2012-01-01 00:00:00', 1, NULL),
(6, 'ActivityNew', 'Aktivnosti - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(11, 'ActivityReordering', 'Aktivnost - Reorder', '2012-01-01 00:00:00', 1, NULL),
(12, 'ActivityResourcesDelete', 'Aktivnost-Resursi - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(13, 'ActivityResourcesEdit', 'Aktivnost-Resursi - Izmena', '2012-01-01 00:00:00', 1, NULL),
(14, 'ActivityResourcesNew', 'Aktivnost-Resursi - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(15, 'ActivityResourcesView', 'Aktivnost-Resursi - Pregled', '2012-01-01 00:00:00', 1, NULL),
(16, 'ActivityUpdateNew', 'Aktivnost – Zabilješke - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(17, 'ActivityUpdateView', 'Aktivnost – Zabilješke - Pregled', '2012-01-01 00:00:00', 1, NULL),
(18, 'ActivityUserDelete', 'Aktivnost-korisnici - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(19, 'ActivityUserNew', 'Aktivnost-korisnici - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(20, 'ActivityUserView', 'Aktivnost-korisnici - Pregled', '2012-01-01 00:00:00', 1, NULL),
(21, 'ActivityView', 'Aktivnosti - Pregled', '2012-01-01 00:00:00', 1, NULL),
(22, 'AdministrationCodeTablesDelete', 'Administracija - Šifarnici - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(23, 'AdministrationCodeTablesEdit', 'Administracija - Šifarnici - Izmena', '2012-01-01 00:00:00', 1, NULL),
(24, 'AdministrationCodeTablesNew', 'Administracija - Šifarnici - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(25, 'AdministrationCodeTablesView', 'Administracija - Šifarnici - Pregled', '2012-01-01 00:00:00', 1, NULL),
(26, 'AdministrationRoleDelete', 'Administracija - Role - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(27, 'AdministrationRoleEdit', 'Administracija - Role - Izmena', '2012-01-01 00:00:00', 1, NULL),
(28, 'AdministrationRoleNew', 'Administracija - Role - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(29, 'AdministrationRoleView', 'Administracija - Role - Pregled', '2012-01-01 00:00:00', 1, NULL),
(30, 'AdministrationUsersDelete', 'Administracija – Korisnici - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(31, 'AdministrationUsersEdit', 'Administracija – Korisnici - Izmena', '2012-01-01 00:00:00', 1, NULL),
(32, 'AdministrationUsersNew', 'Administracija – Korisnici - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(33, 'AdministrationUsersView', 'Administracija – Korisnici - Pregled', '2012-01-01 00:00:00', 1, NULL),
(34, 'CalendarView', 'Kalendar - Pregled', '2012-01-01 00:00:00', 1, NULL),
(35, 'MilestoneDelete', 'Kljucni dogadaji - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(36, 'MilestoneEdit', 'Kljucni dogadaji - Izmena', '2012-01-01 00:00:00', 1, NULL),
(37, 'MilestoneNew', 'Kljucni dogadaji - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(38, 'MilestoneView', 'Kljucni dogadaji - Pregled', '2012-01-01 00:00:00', 1, NULL),
(39, 'ProjectAlterationDelete', 'Promjena na projektu - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(40, 'ProjectAlterationEdit', 'Promjena na projektu - Izmena', '2012-01-01 00:00:00', 1, NULL),
(41, 'ProjectAlterationNew', 'Promjena na projektu - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(42, 'ProjectAlterationView', 'Promjena na projektu - Pregled', '2012-01-01 00:00:00', 1, NULL),
(43, 'ProjectApliedDelete', 'Projekat apliciran - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(44, 'ProjectApliedNew', 'Projekat apliciran - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(45, 'ProjectApliedView', 'Projekat apliciran - Pregled', '2012-01-01 00:00:00', 1, NULL),
(46, 'ProjectBudgetDelete', 'Budžet projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(47, 'ProjectBudgetEdit', 'Budžet projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(48, 'ProjectBudgetNew', 'Budžet projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(49, 'ProjectBudgetView', 'Budžet projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(50, 'ProjectDelete', 'Projekti - Brisanje projekta', '2012-01-01 00:00:00', 1, NULL),
(51, 'ProjectDemographicDataDelete', 'Demografski podaci projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(52, 'ProjectDemographicDataEdit', 'Demografski podaci projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(53, 'ProjectDemographicDataNew', 'Demografski podaci projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(54, 'ProjectDemographicDataView', 'Demografski podaci projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(55, 'ProjectDocumentsDelete', 'Dokumenti projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(56, 'ProjectDocumentsEdit', 'Dokumenti projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(57, 'ProjectDocumentsNew', 'Dokumenti projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(58, 'ProjectDocumentsView', 'Dokumenti projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(59, 'ProjectEdit', 'Projekti - Izmena', '2012-01-01 00:00:00', 1, NULL),
(60, 'ProjectEditAll', 'Projekti - Izmena svih projekata', '2012-01-01 00:00:00', 1, NULL),
(61, 'ProjectExpensesDelete', 'Troškovi projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(62, 'ProjectExpensesEdit', 'Troškovi projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(63, 'ProjectExpensesNew', 'Troškovi projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(64, 'ProjectExpensesView', 'Troškovi projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(65, 'ProjectLocationDelete', 'Lokacije projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(66, 'ProjectLocationEdit', 'Lokacije projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(67, 'ProjectLocationNew', 'Lokacije projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(68, 'ProjectLogMatrixDelete', 'Logicka matrica - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(69, 'ProjectLogMatrixEdit', 'Logicka matrica - Izmena', '2012-01-01 00:00:00', 1, NULL),
(70, 'ProjectLogMatrixNew', 'Logicka matrica - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(71, 'ProjectLogMatrixView', 'Logicka matrica - Pregled', '2012-01-01 00:00:00', 1, NULL),
(72, 'ProjectNew', 'Projekti - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(73, 'ProjectProblemsDelete', 'Problemi projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(74, 'ProjectProblemsEdit', 'Problemi projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(75, 'ProjectProblemsNew', 'Problemi projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(79, 'ProjectProblemsView', 'Problemi projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(80, 'ProjectRiskDelete', 'Rizik projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(81, 'ProjectRiskEdit', 'Rizik projekta - Izmena', '2012-01-01 00:00:00', 1, NULL),
(82, 'ProjectRiskNew', 'Rizik projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(83, 'ProjectRiskView', 'Rizik projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(87, 'ProjectUsersDelete', 'Korisnici projekta - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(88, 'ProjectUsersNew', 'Korisnici projekta - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(89, 'ProjectUsersView', 'Korisnici projekta - Pregled', '2012-01-01 00:00:00', 1, NULL),
(90, 'ProjectView', 'Projekti - Pregled', '2012-01-01 00:00:00', 1, NULL),
(91, 'ProjectViewAll', 'Projekti - Pregled svih projekata', '2012-01-01 00:00:00', 1, NULL),
(96, 'TeamMembersDelete', 'Clanovi tima - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(97, 'TeamMembersEdit', 'Clanovi tima - Izmena', '2012-01-01 00:00:00', 1, NULL),
(98, 'TeamMembersNew', 'Clanovi tima - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(99, 'TeamMembersView', 'Clanovi tima - Pregled', '2012-01-01 00:00:00', 1, NULL),
(100, 'TimeUseDelete', 'Utrošak vrijemena - Brisanje', '2012-01-01 00:00:00', 1, NULL),
(101, 'TimeUseEdit', 'Utrošak vrijemena - Izmena', '2012-01-01 00:00:00', 1, NULL),
(102, 'TimeUseNew', 'Utrošak vrijemena - Kreiranje', '2012-01-01 00:00:00', 1, NULL),
(103, 'TimeUseView', 'Utrošak vrijemena - Pregled', '2012-01-01 00:00:00', 1, NULL),
(104, 'ProblemUpdateNew', 'Issue notes - Edit', '2012-01-01 00:00:00', 1, NULL),
(106, 'ProblemUpdateView', 'Issue notes - View', '2012-01-01 00:00:00', 1, NULL),
(107, 'RiskUpdateNew', 'Risk notes - Edit', '2012-01-01 00:00:00', 1, NULL),
(108, 'RiskUpdateView', 'Risk notes - View', '2012-01-01 00:00:00', 1, NULL),
(109, 'AlterationUpdateNew', 'Change notes - Edit', '2012-01-01 00:00:00', 1, NULL),
(110, 'AlterationUpdateView', 'Change notes - View', '2012-01-01 00:00:00', 1, NULL),
(111, 'ProjectLocationView', 'Project Location-View', NULL, 1, NULL),
(112, 'ViewDojo', 'Pregled svih projekata', '2017-04-05 00:00:00', 1, NULL),
(113, 'ProjectResourceAdd', 'Project Resources Add', '2019-05-12 00:00:00', 1, NULL),
(114, 'ProjectResourceEdit', 'Project Resources Edit', '2019-05-12 10:44:55', 1, NULL),
(115, 'ProjectResourceDelete', 'Project Resources Delete', '2019-05-12 00:00:00', 1, NULL),
(116, 'ProjectResourceView', 'Project Resources View', '2019-05-12 00:00:00', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `problem`
--

DROP TABLE IF EXISTS `problem`;
CREATE TABLE IF NOT EXISTS `problem` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `Name` varchar(512) NOT NULL,
  `Description` varchar(2048) DEFAULT NULL,
  `IsClosed` bit(1) NOT NULL,
  `Informee` varchar(512) DEFAULT NULL,
  `InformationDate` datetime DEFAULT NULL,
  `ResolveUntil` datetime DEFAULT NULL,
  `Influence` int(11) DEFAULT NULL,
  `Priority` int(11) DEFAULT NULL,
  `SolveDate` datetime DEFAULT NULL,
  `SolveDescription` varchar(2048) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `problemactivity`
--

DROP TABLE IF EXISTS `problemactivity`;
CREATE TABLE IF NOT EXISTS `problemactivity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProblemId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `ProblemId` (`ProblemId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `problemdocument`
--

DROP TABLE IF EXISTS `problemdocument`;
CREATE TABLE IF NOT EXISTS `problemdocument` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `ProblemId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProblemId` (`ProblemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `problemdocumentnote`
--

DROP TABLE IF EXISTS `problemdocumentnote`;
CREATE TABLE IF NOT EXISTS `problemdocumentnote` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `ProblemId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `ContentLength` longtext DEFAULT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProblemId` (`ProblemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `problemupdate`
--

DROP TABLE IF EXISTS `problemupdate`;
CREATE TABLE IF NOT EXISTS `problemupdate` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProblemUpdate` longtext NOT NULL,
  `ProblemId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProblemId` (`ProblemId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `problemuser`
--

DROP TABLE IF EXISTS `problemuser`;
CREATE TABLE IF NOT EXISTS `problemuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProblemId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProblemId` (`ProblemId`),
  KEY `UserId` (`UserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
CREATE TABLE IF NOT EXISTS `project` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(500) NOT NULL,
  `ProjectNumber` varchar(255) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `ProjectCategoryId` bigint(20) DEFAULT NULL,
  `ProjectLocationId` bigint(20) DEFAULT NULL,
  `ProjectPrice` decimal(18,3) DEFAULT NULL,
  `ManagerId` bigint(20) NOT NULL,
  `CurrencyId` bigint(20) DEFAULT NULL,
  `StartDate` datetime DEFAULT NULL,
  `EndDate` datetime DEFAULT NULL,
  `PriorityId` bigint(20) DEFAULT NULL,
  `ProjectStatusId` bigint(20) NOT NULL,
  `LegalBaseId` bigint(20) DEFAULT NULL,
  `AplicantId` bigint(20) DEFAULT NULL,
  `Note` longtext DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `ConceptNote` longtext DEFAULT NULL,
  `ProjectInAccordanceWithId` bigint(20) DEFAULT NULL,
  `AlternativeCurrencyId` bigint(20) DEFAULT NULL,
  `IsArchived` tinyint(4) NOT NULL DEFAULT 0,
  `ArchivedDate` datetime DEFAULT NULL,
  `IsPrivate` bit(1) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `AlternativeCurrencyId` (`AlternativeCurrencyId`),
  KEY `ProjectInAccordanceWithId` (`ProjectInAccordanceWithId`),
  KEY `PriorityId` (`PriorityId`),
  KEY `ProjectStatusId` (`ProjectStatusId`),
  KEY `ManagerId` (`ManagerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectapplied`
--

DROP TABLE IF EXISTS `projectapplied`;
CREATE TABLE IF NOT EXISTS `projectapplied` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `InstitutionTypeId` bigint(20) NOT NULL,
  `Address` varchar(500) DEFAULT NULL,
  `ContactPersonName` varchar(500) DEFAULT NULL,
  `TelephoneNumber` varchar(50) DEFAULT NULL,
  `Email` varchar(500) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `EndDate` datetime DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `InstitutionTypeId` (`InstitutionTypeId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectappliedlocalized`
--

DROP TABLE IF EXISTS `projectappliedlocalized`;
CREATE TABLE IF NOT EXISTS `projectappliedlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `Address` varchar(500) DEFAULT NULL,
  `TelephoneNumber` varchar(50) DEFAULT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectbudget`
--

DROP TABLE IF EXISTS `projectbudget`;
CREATE TABLE IF NOT EXISTS `projectbudget` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `OrganizationUnitId` bigint(20) NOT NULL,
  `Value` decimal(18,3) NOT NULL,
  `CurrencyId` bigint(20) NOT NULL,
  `ComputedCurrencyId` bigint(20) DEFAULT NULL,
  `ComputedValue` decimal(18,3) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CurrencyId` (`CurrencyId`),
  KEY `OrganizationUnitId` (`OrganizationUnitId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `projectcategory`
--

DROP TABLE IF EXISTS `projectcategory`;
CREATE TABLE IF NOT EXISTS `projectcategory` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectcategory`
--

INSERT INTO `projectcategory` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'Social projects', '2014-04-11 07:49:58', 1, NULL),
(2, '2', 'Economic projects', '2014-04-11 07:50:09', 1, NULL),
(3, '3', 'Commercial projects', '2014-04-11 07:50:25', 1, NULL),
(4, '4', 'Marketing Projects', '2014-04-11 07:50:41', 1, NULL),
(5, '5', 'Software projects', '2014-04-11 07:50:58', 1, NULL),
(6, '6', 'Public projects', '2014-04-11 07:52:50', 1, NULL),
(7, '7', 'Infrastructure projects', '2014-04-11 12:25:15', 1, NULL),
(8, '8', 'Other projects', '2014-04-11 12:25:38', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectcategorylocalized`
--

DROP TABLE IF EXISTS `projectcategorylocalized`;
CREATE TABLE IF NOT EXISTS `projectcategorylocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectcategorylocalized`
--

INSERT INTO `projectcategorylocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Socijalni projekti', '2014-04-11 07:49:58', 1, NULL),
(2, 'en-US', 1, '1', 'Social projects', '2014-04-11 07:49:58', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'Ekonomski projekti', '2014-04-11 07:50:09', 1, NULL),
(4, 'en-US', 2, '2', 'Economic projects', '2014-04-11 07:50:09', 1, NULL),
(5, 'sr-Latn-RS', 3, '3', 'Privredni projekti', '2014-04-11 07:50:25', 1, NULL),
(6, 'en-US', 3, '3', 'Commercial projects', '2014-04-11 07:50:25', 1, NULL),
(7, 'sr-Latn-RS', 4, '4', 'Marketing Projekti', '2014-04-11 07:50:41', 1, NULL),
(8, 'en-US', 4, '4', 'Marketing Projects', '2014-04-11 07:50:41', 1, NULL),
(9, 'sr-Latn-RS', 5, '5', 'Softverski projekti', '2014-04-11 07:50:58', 1, NULL),
(10, 'en-US', 5, '5', 'Software projects', '2014-04-11 07:50:58', 1, NULL),
(11, 'sr-Latn-RS', 6, '6', 'Javni Projekti', '2014-04-11 07:52:50', 1, NULL),
(12, 'en-US', 6, '6', 'Public projects', '2014-04-11 07:52:50', 1, NULL),
(13, 'sr-Latn-RS', 7, '7', 'Infrastrukturni projekti', '2014-04-11 12:25:15', 1, NULL),
(14, 'en-US', 7, '7', 'Infrastructure projects', '2014-04-11 12:25:15', 1, NULL),
(15, 'sr-Latn-RS', 8, '8', 'Ostali projekti', '2014-04-11 12:25:38', 1, NULL),
(16, 'en-US', 8, '8', 'Other projects', '2014-04-11 12:25:38', 1, NULL),
(17, 'en-AU', 1, '1', 'Social projects', '2014-04-11 07:49:58', 1, NULL),
(18, 'en-AU', 2, '2', 'Economic projects', '2014-04-11 07:50:09', 1, NULL),
(19, 'en-AU', 3, '3', 'Commercial projects', '2014-04-11 07:50:25', 1, NULL),
(20, 'en-AU', 4, '4', 'Marketing Projects', '2014-04-11 07:50:41', 1, NULL),
(21, 'en-AU', 5, '5', 'Software projects', '2014-04-11 07:50:58', 1, NULL),
(22, 'en-AU', 6, '6', 'Public projects', '2014-04-11 07:52:50', 1, NULL),
(23, 'en-AU', 7, '7', 'Infrastructure projects', '2014-04-11 12:25:15', 1, NULL),
(24, 'en-AU', 8, '8', 'Other projects', '2014-04-11 12:25:38', 1, NULL),
(32, 'bs-BA', 1, '1', 'Socijalni projekti', '2014-04-11 07:49:58', 1, NULL),
(33, 'bs-BA', 2, '2', 'Ekonomski projekti', '2014-04-11 07:50:09', 1, NULL),
(34, 'bs-BA', 3, '3', 'Privredni projekti', '2014-04-11 07:50:25', 1, NULL),
(35, 'bs-BA', 4, '4', 'Marketing Projekti', '2014-04-11 07:50:41', 1, NULL),
(36, 'bs-BA', 5, '5', 'Softverski projekti', '2014-04-11 07:50:58', 1, NULL),
(37, 'bs-BA', 6, '6', 'Javni Projekti', '2014-04-11 07:52:50', 1, NULL),
(38, 'bs-BA', 7, '7', 'Infrastrukturni projekti', '2014-04-11 12:25:15', 1, NULL),
(39, 'bs-BA', 8, '8', 'Ostali projekti', '2014-04-11 12:25:38', 1, NULL),
(47, 'hr-HR', 1, '1', 'Socijalni projekti', '2014-04-11 07:49:58', 1, NULL),
(48, 'hr-HR', 2, '2', 'Ekonomski projekti', '2014-04-11 07:50:09', 1, NULL),
(49, 'hr-HR', 3, '3', 'Privredni projekti', '2014-04-11 07:50:25', 1, NULL),
(50, 'hr-HR', 4, '4', 'Marketing Projekti', '2014-04-11 07:50:41', 1, NULL),
(51, 'hr-HR', 5, '5', 'Softverski projekti', '2014-04-11 07:50:58', 1, NULL),
(52, 'hr-HR', 6, '6', 'Javni Projekti', '2014-04-11 07:52:50', 1, NULL),
(53, 'hr-HR', 7, '7', 'Infrastrukturni projekti', '2014-04-11 12:25:15', 1, NULL),
(54, 'hr-HR', 8, '8', 'Ostali projekti', '2014-04-11 12:25:38', 1, NULL),
(62, 'de-DE', 1, '1', 'Soziale Projekte', '2014-04-11 07:49:58', 1, NULL),
(63, 'de-DE', 2, '2', 'Wirtschaftsprojekte', '2014-04-11 07:50:09', 1, NULL),
(64, 'de-DE', 3, '3', 'Kommerzielle Projekte', '2014-04-11 07:50:25', 1, NULL),
(65, 'de-DE', 4, '4', 'Marketing Projekte', '2014-04-11 07:50:41', 1, NULL),
(66, 'de-DE', 5, '5', 'Software Projekte', '2014-04-11 07:50:58', 1, NULL),
(67, 'de-DE', 6, '6', 'Öffentliche Projekte', '2014-04-11 07:52:50', 1, NULL),
(68, 'de-DE', 7, '7', 'Infrastrukturprojekte', '2014-04-11 12:25:15', 1, NULL),
(69, 'de-DE', 8, '8', 'Weitere Projekte', '2014-04-11 12:25:38', 1, NULL),
(70, 'es-ES', 1, '1', 'Proyectos sociales', '2020-04-16 23:25:37', 1, NULL),
(71, 'es-ES', 2, '2', 'Proyectos economicos', '2020-04-16 23:25:37', 1, NULL),
(72, 'es-ES', 3, '3', 'Proyectos comerciales', '2020-04-16 23:25:38', 1, NULL),
(73, 'es-ES', 4, '4', 'Proyectos de mercadeo', '2020-04-16 23:25:38', 1, NULL),
(74, 'es-ES', 5, '5', 'Proyectos de software', '2020-04-16 23:25:38', 1, NULL),
(75, 'es-ES', 6, '6', 'Proyectos públicos', '2020-04-16 23:25:38', 1, NULL),
(76, 'es-ES', 7, '7', 'Proyectos de infraestructura', '2020-04-16 23:25:38', 1, NULL),
(77, 'es-ES', 8, '8', 'Otros proyectos', '2020-04-16 23:25:38', 1, NULL),
(78, 'en-GB', 1, '1', 'Social projects', '2022-02-01 20:57:25', 1, NULL),
(79, 'en-GB', 2, '2', 'Economic projects', '2022-02-01 20:57:25', 1, NULL),
(80, 'en-GB', 3, '3', 'Commercial projects', '2022-02-01 20:57:25', 1, NULL),
(81, 'en-GB', 4, '4', 'Marketing Projects', '2022-02-01 20:57:25', 1, NULL),
(82, 'en-GB', 5, '5', 'Software projects', '2022-02-01 20:57:25', 1, NULL),
(83, 'en-GB', 6, '6', 'Public projects', '2022-02-01 20:57:25', 1, NULL),
(84, 'en-GB', 7, '7', 'Infrastructure projects', '2022-02-01 20:57:25', 1, NULL),
(85, 'en-GB', 8, '8', 'Other projects', '2022-02-01 20:57:25', 1, NULL),
(86, 'en-UK', 1, '1', 'Družbeni projekti', '2022-02-01 20:57:26', 1, NULL),
(87, 'en-UK', 2, '2', 'Ekonomski projekti', '2022-02-01 20:57:26', 1, NULL),
(88, 'en-UK', 3, '3', 'Gospodarski projekti', '2022-02-01 20:57:26', 1, NULL),
(89, 'en-UK', 4, '4', 'Marketninški projekti', '2022-02-01 20:57:26', 1, NULL),
(90, 'en-UK', 5, '5', 'Softwerski projekti', '2022-02-01 20:57:26', 1, NULL),
(91, 'en-UK', 6, '6', 'Javni projekti', '2022-02-01 20:57:26', 1, NULL),
(92, 'en-UK', 7, '7', 'Infrastrukturni projekti', '2022-02-01 20:57:26', 1, NULL),
(93, 'en-UK', 8, '8', 'Ostali projekti', '2022-02-01 20:57:26', 1, NULL),
(94, 'it-IT', 1, '1', 'Progetti sociali', '2022-02-01 20:57:26', 1, NULL),
(95, 'it-IT', 2, '2', 'Progetti economici', '2022-02-01 20:57:26', 1, NULL),
(96, 'it-IT', 3, '3', 'Progetti commerciali', '2022-02-01 20:57:26', 1, NULL),
(97, 'it-IT', 4, '4', 'Progetti di marketing', '2022-02-01 20:57:26', 1, NULL),
(98, 'it-IT', 5, '5', 'Progetti del Software', '2022-02-01 20:57:26', 1, NULL),
(99, 'it-IT', 6, '6', 'Progetti pubblici', '2022-02-01 20:57:26', 1, NULL),
(100, 'it-IT', 7, '7', 'Progetti infrastrutturali', '2022-02-01 20:57:26', 1, NULL),
(101, 'it-IT', 8, '8', 'Altri progetti', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectdemographicdata`
--

DROP TABLE IF EXISTS `projectdemographicdata`;
CREATE TABLE IF NOT EXISTS `projectdemographicdata` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ProjectUserId` bigint(20) NOT NULL,
  `Description` varchar(1024) DEFAULT NULL,
  `NumberOfUsers` int(11) NOT NULL,
  `GenderPresence` tinyint(4) NOT NULL,
  `Men` int(11) DEFAULT NULL,
  `MenInPercentage` tinyint(4) DEFAULT NULL,
  `Women` int(11) DEFAULT NULL,
  `WomenInPercentage` tinyint(4) DEFAULT NULL,
  `Children` int(11) DEFAULT NULL,
  `ChildrenInPercentage` tinyint(4) DEFAULT NULL,
  `Unknown` int(11) DEFAULT NULL,
  `UnknownInPercentage` tinyint(4) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `ProjectUserId` (`ProjectUserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectdocument`
--

DROP TABLE IF EXISTS `projectdocument`;
CREATE TABLE IF NOT EXISTS `projectdocument` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `ProjectId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectgoalstree`
--

DROP TABLE IF EXISTS `projectgoalstree`;
CREATE TABLE IF NOT EXISTS `projectgoalstree` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `FileName` varchar(50) NOT NULL,
  `DocumentName` varchar(70) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(350) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectinaccordancewith`
--

DROP TABLE IF EXISTS `projectinaccordancewith`;
CREATE TABLE IF NOT EXISTS `projectinaccordancewith` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectinaccordancewith`
--

INSERT INTO `projectinaccordancewith` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'Development Strategy', '2014-04-11 08:10:12', 1, NULL),
(2, '2', 'Marketing strategy', '2014-04-11 08:10:28', 1, NULL),
(3, '3', 'Business Strategy', '2014-04-11 08:10:39', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectinaccordancewithlocalized`
--

DROP TABLE IF EXISTS `projectinaccordancewithlocalized`;
CREATE TABLE IF NOT EXISTS `projectinaccordancewithlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectinaccordancewithlocalized`
--

INSERT INTO `projectinaccordancewithlocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Strategijom razvoja', '2014-04-11 08:10:12', 1, NULL),
(2, 'en-US', 1, '1', 'Development Strategy', '2014-04-11 08:10:12', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'Marketing strategija', '2014-04-11 08:10:28', 1, NULL),
(4, 'en-US', 2, '2', 'Marketing strategy', '2014-04-11 08:10:28', 1, NULL),
(5, 'sr-Latn-RS', 3, '3', 'Biznis Strategija', '2014-04-11 08:10:39', 1, NULL),
(6, 'en-US', 3, '3', 'Business Strategy', '2014-04-11 08:10:39', 1, NULL),
(7, 'en-AU', 1, '1', 'Development Strategy', '2014-04-11 08:10:12', 1, NULL),
(8, 'en-AU', 2, '2', 'Marketing strategy', '2014-04-11 08:10:28', 1, NULL),
(9, 'en-AU', 3, '3', 'Business Strategy', '2014-04-11 08:10:39', 1, NULL),
(10, 'bs-BA', 1, '1', 'Strategijom razvoja', '2014-04-11 08:10:12', 1, NULL),
(11, 'bs-BA', 2, '2', 'Marketing strategija', '2014-04-11 08:10:28', 1, NULL),
(12, 'bs-BA', 3, '3', 'Biznis Strategija', '2014-04-11 08:10:39', 1, NULL),
(13, 'hr-HR', 1, '1', 'Strategijom razvoja', '2014-04-11 08:10:12', 1, NULL),
(14, 'hr-HR', 2, '2', 'Marketing strategija', '2014-04-11 08:10:28', 1, NULL),
(15, 'hr-HR', 3, '3', 'Biznis Strategija', '2014-04-11 08:10:39', 1, NULL),
(16, 'de-DE', 1, '1', 'Entwicklungsstrategie', '2014-04-11 08:10:12', 1, NULL),
(17, 'de-DE', 2, '2', 'Vermarktungsstrategie', '2014-04-11 08:10:28', 1, NULL),
(18, 'de-DE', 3, '3', 'Geschäftsstrategie', '2014-04-11 08:10:39', 1, NULL),
(19, 'es-ES', 1, '1', 'Estrategia de desarrollo', '2020-04-16 23:25:38', 1, NULL),
(20, 'es-ES', 2, '2', 'Estrategia de mercadeo', '2020-04-16 23:25:38', 1, NULL),
(21, 'es-ES', 3, '3', 'Estrategia de negocios', '2020-04-16 23:25:38', 1, NULL),
(22, 'en-GB', 1, '1', 'Product Development', '2022-02-01 20:57:25', 1, NULL),
(23, 'en-GB', 2, '2', 'Marketing strategy', '2022-02-01 20:57:25', 1, NULL),
(24, 'en-GB', 3, '3', 'Business Strategy', '2022-02-01 20:57:25', 1, NULL),
(25, 'en-UK', 1, '1', 'Razvojna strategija', '2022-02-01 20:57:26', 1, NULL),
(26, 'en-UK', 2, '2', 'Marketinška strategija', '2022-02-01 20:57:26', 1, NULL),
(27, 'en-UK', 3, '3', 'Poslovna strategija', '2022-02-01 20:57:26', 1, NULL),
(28, 'it-IT', 1, '1', 'Strategia di sviluppo', '2022-02-01 20:57:26', 1, NULL),
(29, 'it-IT', 2, '2', 'Strategia di marketing', '2022-02-01 20:57:26', 1, NULL),
(30, 'it-IT', 3, '3', 'Business strategia', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectlocation`
--

DROP TABLE IF EXISTS `projectlocation`;
CREATE TABLE IF NOT EXISTS `projectlocation` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectlocationlocalized`
--

DROP TABLE IF EXISTS `projectlocationlocalized`;
CREATE TABLE IF NOT EXISTS `projectlocationlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectpriority`
--

DROP TABLE IF EXISTS `projectpriority`;
CREATE TABLE IF NOT EXISTS `projectpriority` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectpriority`
--

INSERT INTO `projectpriority` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'High', '2014-04-11 07:47:46', 1, NULL),
(2, '2', 'Low', '2014-04-11 07:48:01', 1, NULL),
(3, '3', 'Normal', '2014-04-11 07:48:20', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectprioritylocalized`
--

DROP TABLE IF EXISTS `projectprioritylocalized`;
CREATE TABLE IF NOT EXISTS `projectprioritylocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `PriorityId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectprioritylocalized`
--

INSERT INTO `projectprioritylocalized` (`Id`, `LanguageCode`, `PriorityId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Visok ', '2014-04-11 07:47:46', 1, NULL),
(2, 'en-US', 1, '1', 'High', '2014-04-11 07:47:46', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'Nizak', '2014-04-11 07:48:01', 1, NULL),
(4, 'en-US', 2, '2', 'Low', '2014-04-11 07:48:01', 1, NULL),
(5, 'sr-Latn-RS', 3, '3', 'Normalan', '2014-04-11 07:48:20', 1, NULL),
(6, 'en-US', 3, '3', 'Normal', '2014-04-11 07:48:20', 1, NULL),
(7, 'en-AU', 1, '1', 'High', '2014-04-11 07:47:46', 1, NULL),
(8, 'en-AU', 2, '2', 'Low', '2014-04-11 07:48:01', 1, NULL),
(9, 'en-AU', 3, '3', 'Normal', '2014-04-11 07:48:20', 1, NULL),
(10, 'bs-BA', 1, '1', 'Visok ', '2014-04-11 07:47:46', 1, NULL),
(11, 'bs-BA', 2, '2', 'Nizak', '2014-04-11 07:48:01', 1, NULL),
(12, 'bs-BA', 3, '3', 'Normalan', '2014-04-11 07:48:20', 1, NULL),
(13, 'hr-HR', 1, '1', 'Visok ', '2014-04-11 07:47:46', 1, NULL),
(14, 'hr-HR', 2, '2', 'Nizak', '2014-04-11 07:48:01', 1, NULL),
(15, 'hr-HR', 3, '3', 'Normalan', '2014-04-11 07:48:20', 1, NULL),
(16, 'de-DE', 1, '1', 'Hoch', '2014-04-11 07:47:46', 1, NULL),
(17, 'de-DE', 2, '2', 'Niedrig', '2014-04-11 07:48:01', 1, NULL),
(18, 'de-DE', 3, '3', 'Normal', '2014-04-11 07:48:20', 1, NULL),
(19, 'es-ES', 1, '1', 'Alto', '2020-04-16 23:25:38', 1, NULL),
(20, 'es-ES', 2, '2', 'Bajo', '2020-04-16 23:25:39', 1, NULL),
(21, 'es-ES', 3, '3', 'Normal', '2020-04-16 23:25:39', 1, NULL),
(22, 'en-GB', 1, '1', 'High', '2022-02-01 20:57:25', 1, NULL),
(23, 'en-GB', 2, '2', 'Low', '2022-02-01 20:57:25', 1, NULL),
(24, 'en-GB', 3, '3', 'Normal', '2022-02-01 20:57:25', 1, NULL),
(25, 'en-UK', 1, '1', 'High', '2022-02-01 20:57:26', 1, NULL),
(26, 'en-UK', 2, '2', 'Low', '2022-02-01 20:57:26', 1, NULL),
(27, 'en-UK', 3, '3', 'Normal', '2022-02-01 20:57:26', 1, NULL),
(28, 'it-IT', 1, '1', 'High', '2022-02-01 20:57:26', 1, NULL),
(29, 'it-IT', 2, '2', 'Low', '2022-02-01 20:57:26', 1, NULL),
(30, 'it-IT', 3, '3', 'Normal', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectproblemtree`
--

DROP TABLE IF EXISTS `projectproblemtree`;
CREATE TABLE IF NOT EXISTS `projectproblemtree` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `FileName` varchar(50) NOT NULL,
  `DocumentName` varchar(70) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(350) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectprojectapplied`
--

DROP TABLE IF EXISTS `projectprojectapplied`;
CREATE TABLE IF NOT EXISTS `projectprojectapplied` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ProjectAppliedId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `ProjectAppliedId` (`ProjectAppliedId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `projectprojectlocation`
--

DROP TABLE IF EXISTS `projectprojectlocation`;
CREATE TABLE IF NOT EXISTS `projectprojectlocation` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ProjectLocationId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `ProjectLocationId` (`ProjectLocationId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `projectprojectuser`
--

DROP TABLE IF EXISTS `projectprojectuser`;
CREATE TABLE IF NOT EXISTS `projectprojectuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ProjectUserId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `ProjectUserId` (`ProjectUserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectresource`
--

DROP TABLE IF EXISTS `projectresource`;
CREATE TABLE IF NOT EXISTS `projectresource` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ResourceId` bigint(60) NOT NULL,
  `ResourceTypeId` bigint(20) NOT NULL,
  `ValueProjectResource` bigint(20) NOT NULL,
  `Cost` decimal(10,2) NOT NULL,
  `DateCreated` date NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  `PlanedAmount` decimal(10,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`Id`),
  KEY `FK_projectresource_reosurcetype` (`ResourceTypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectsettings`
--

DROP TABLE IF EXISTS `projectsettings`;
CREATE TABLE IF NOT EXISTS `projectsettings` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `DashbordVisible` tinyint(4) DEFAULT NULL,
  `BasicDataVisible` tinyint(4) DEFAULT NULL,
  `TeamMembersVisible` tinyint(4) DEFAULT NULL,
  `CalendarVisible` tinyint(4) DEFAULT NULL,
  `LocationsVisible` tinyint(4) DEFAULT NULL,
  `ProjectAppliedVisible` tinyint(4) DEFAULT NULL,
  `ProjectUsersVisible` tinyint(4) DEFAULT NULL,
  `BudgetVisible` tinyint(4) DEFAULT NULL,
  `DemographicDataVisible` tinyint(4) DEFAULT NULL,
  `DocumentsVisible` tinyint(4) DEFAULT NULL,
  `LogframeVisible` tinyint(4) DEFAULT NULL,
  `ActivitiesVisible` tinyint(4) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DefaultActivityView` int(11) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `projectstatus`
--

DROP TABLE IF EXISTS `projectstatus`;
CREATE TABLE IF NOT EXISTS `projectstatus` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectstatus`
--

INSERT INTO `projectstatus` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'On hold', '2014-04-11 07:48:43', 1, NULL),
(2, '2', 'Open', '2014-04-11 07:48:58', 1, NULL),
(3, '3', 'Closed', '2014-04-11 07:49:15', 1, NULL),
(4, '4', 'In progress ', '2014-04-11 07:49:30', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectstatuslocalized`
--

DROP TABLE IF EXISTS `projectstatuslocalized`;
CREATE TABLE IF NOT EXISTS `projectstatuslocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `projectstatuslocalized`
--

INSERT INTO `projectstatuslocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(9, 'sr-Latn-RS', 1, '1', 'Na čekanju', '2014-04-11 07:48:43', 1, NULL),
(10, 'en-US', 1, '1', 'On hold', '2014-04-11 07:48:43', 1, NULL),
(11, 'sr-Latn-RS', 2, '2', 'Otvoren', '2014-04-11 07:48:58', 1, NULL),
(12, 'en-US', 2, '2', 'Open', '2014-04-11 07:48:58', 1, NULL),
(13, 'sr-Latn-RS', 3, '3', 'Zatvoren', '2014-04-11 07:49:15', 1, NULL),
(14, 'en-US', 3, '3', 'Closed', '2014-04-11 07:49:15', 1, NULL),
(15, 'sr-Latn-RS', 4, '4', 'U toku ', '2014-04-11 07:49:30', 1, NULL),
(16, 'en-US', 4, '4', 'In progress ', '2014-04-11 07:49:30', 1, NULL),
(17, 'en-AU', 1, '1', 'On hold', '2014-04-11 07:48:43', 1, NULL),
(18, 'en-AU', 2, '2', 'Open', '2014-04-11 07:48:58', 1, NULL),
(19, 'en-AU', 3, '3', 'Closed', '2014-04-11 07:49:15', 1, NULL),
(20, 'en-AU', 4, '4', 'In progress ', '2014-04-11 07:49:30', 1, NULL),
(24, 'bs-BA', 1, '1', 'Na čekanju', '2014-04-11 07:48:43', 1, NULL),
(25, 'bs-BA', 2, '2', 'Otvoren', '2014-04-11 07:48:58', 1, NULL),
(26, 'bs-BA', 3, '3', 'Zatvoren', '2014-04-11 07:49:15', 1, NULL),
(27, 'bs-BA', 4, '4', 'U toku ', '2014-04-11 07:49:30', 1, NULL),
(31, 'hr-HR', 1, '1', 'Na čekanju', '2014-04-11 07:48:43', 1, NULL),
(32, 'hr-HR', 2, '2', 'Otvoren', '2014-04-11 07:48:58', 1, NULL),
(33, 'hr-HR', 3, '3', 'Zatvoren', '2014-04-11 07:49:15', 1, NULL),
(34, 'hr-HR', 4, '4', 'U toku ', '2014-04-11 07:49:30', 1, NULL),
(38, 'de-DE', 1, '1', 'In Wartestellung', '2014-04-11 07:48:43', 1, NULL),
(39, 'de-DE', 2, '2', 'Öffnen', '2014-04-11 07:48:58', 1, NULL),
(40, 'de-DE', 3, '3', 'Geschlossen', '2014-04-11 07:49:15', 1, NULL),
(41, 'de-DE', 4, '4', 'In Bearbeitung', '2014-04-11 07:49:30', 1, NULL),
(42, 'es-ES', 1, '1', 'En espera', '2020-04-16 23:25:39', 1, NULL),
(43, 'es-ES', 2, '2', 'Abierto', '2020-04-16 23:25:39', 1, NULL),
(44, 'es-ES', 3, '3', 'Cerrado', '2020-04-16 23:25:39', 1, NULL),
(45, 'es-ES', 4, '4', 'En progreso', '2020-04-16 23:25:39', 1, NULL),
(46, 'en-GB', 1, '1', 'On hold', '2022-02-01 20:57:25', 1, NULL),
(47, 'en-GB', 2, '2', 'Open', '2022-02-01 20:57:25', 1, NULL),
(48, 'en-GB', 3, '3', 'Closed', '2022-02-01 20:57:25', 1, NULL),
(49, 'en-GB', 4, '4', 'In progress', '2022-02-01 20:57:25', 1, NULL),
(50, 'en-UK', 1, '1', 'Na čakanju', '2022-02-01 20:57:26', 1, NULL),
(51, 'en-UK', 2, '2', 'Odprt', '2022-02-01 20:57:26', 1, NULL),
(52, 'en-UK', 3, '3', 'Zaprt', '2022-02-01 20:57:26', 1, NULL),
(53, 'en-UK', 4, '4', 'V izvajanju', '2022-02-01 20:57:26', 1, NULL),
(54, 'it-IT', 1, '1', 'In attesa', '2022-02-01 20:57:26', 1, NULL),
(55, 'it-IT', 2, '2', 'Aperto', '2022-02-01 20:57:26', 1, NULL),
(56, 'it-IT', 3, '3', 'Chiuso', '2022-02-01 20:57:26', 1, NULL),
(57, 'it-IT', 4, '4', 'In corso', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `projectuser`
--

DROP TABLE IF EXISTS `projectuser`;
CREATE TABLE IF NOT EXISTS `projectuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `projectuserlocalized`
--

DROP TABLE IF EXISTS `projectuserlocalized`;
CREATE TABLE IF NOT EXISTS `projectuserlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL DEFAULT current_timestamp(),
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
CREATE TABLE IF NOT EXISTS `resource` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ResourceName` varchar(60) NOT NULL,
  `ResourceTypeId` bigint(20) NOT NULL,
  `ResourceDescription` varchar(250) DEFAULT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DateCreated` date NOT NULL,
  `DeactivationDate` date DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `FK_resource_reosurcetype` (`ResourceTypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `resourcemesurmentunit`
--

DROP TABLE IF EXISTS `resourcemesurmentunit`;
CREATE TABLE IF NOT EXISTS `resourcemesurmentunit` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `resourcemesurmentunit`
--

INSERT INTO `resourcemesurmentunit` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'per Hour', 'per Hour', '2019-05-12 10:40:47', 1, NULL),
(2, 'per Item', 'per Item', '2019-05-12 10:44:15', 1, NULL),
(3, 'Cost', 'Cost', '2019-05-12 10:44:54', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `resourcemesurmentunitlocalized`
--

DROP TABLE IF EXISTS `resourcemesurmentunitlocalized`;
CREATE TABLE IF NOT EXISTS `resourcemesurmentunitlocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `NameLocalized` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ParentId` (`ParentId`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `resourcemesurmentunitlocalized`
--

INSERT INTO `resourcemesurmentunitlocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `NameLocalized`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, 'per Hour', 'po satu', '2019-05-12 10:40:50', 1, NULL),
(2, 'en-US', 1, 'per Hour', 'per Hour', '2019-05-12 10:40:50', 1, NULL),
(3, 'en-AU', 1, 'per Hour', 'per Hour', '2019-05-12 10:40:50', 1, NULL),
(4, 'de-DE', 1, 'per Hour', 'pro Stunde', '2019-05-12 10:40:50', 1, NULL),
(5, 'hr-HR', 1, 'per Hour', 'po satu', '2019-05-12 10:40:50', 1, NULL),
(6, 'bs-BA', 1, 'per Hour', 'po satu', '2019-05-12 10:40:50', 1, NULL),
(7, 'sr-Latn-RS', 2, 'per Item', 'po komadu', '2019-05-12 10:44:16', 1, NULL),
(8, 'en-US', 2, 'per Item', 'per Item', '2019-05-12 10:44:16', 1, NULL),
(9, 'en-AU', 2, 'per Item', 'per Item', '2019-05-12 10:44:16', 1, NULL),
(10, 'de-DE', 2, 'per Item', 'pro Stück', '2019-05-12 10:44:16', 1, NULL),
(11, 'hr-HR', 2, 'per Item', 'po komadu', '2019-05-12 10:44:16', 1, NULL),
(12, 'bs-BA', 2, 'per Item', 'po komadu', '2019-05-12 10:44:16', 1, NULL),
(13, 'sr-Latn-RS', 3, 'Cost', 'trošak', '2019-05-12 10:44:55', 1, NULL),
(14, 'en-US', 3, 'Cost', 'Cost', '2019-05-12 10:44:55', 1, NULL),
(15, 'en-AU', 3, 'Cost', 'Cost', '2019-05-12 10:44:55', 1, NULL),
(16, 'de-DE', 3, 'Cost', 'Kosten', '2019-05-12 10:44:55', 1, NULL),
(17, 'hr-HR', 3, 'Cost', 'trošak', '2019-05-12 10:44:55', 1, NULL),
(18, 'bs-BA', 3, 'Cost', 'trošak', '2019-05-12 10:44:55', 1, NULL),
(19, 'es-ES', 1, 'per Hour', 'por hora', '2020-04-16 23:25:40', 1, NULL),
(20, 'es-ES', 2, 'per Item', 'por artículo', '2020-04-16 23:25:40', 1, NULL),
(21, 'es-ES', 3, 'Cost', 'Costo', '2020-04-16 23:25:40', 1, NULL),
(22, 'en-GB', 1, 'per Hour', 'per Hour', '2022-02-01 20:57:25', 1, NULL),
(23, 'en-GB', 2, 'per Item', 'por artículo', '2022-02-01 20:57:25', 1, NULL),
(24, 'en-GB', 3, 'Cost', 'Cost', '2022-02-01 20:57:25', 1, NULL),
(25, 'en-UK', 1, 'per Hour', 'na uro', '2022-02-01 20:57:26', 1, NULL),
(26, 'en-UK', 2, 'per Item', 'po enoti', '2022-02-01 20:57:26', 1, NULL),
(27, 'en-UK', 3, 'Cost', 'strošek', '2022-02-01 20:57:26', 1, NULL),
(28, 'it-IT', 1, 'per Hour', 'per ora', '2022-02-01 20:57:26', 1, NULL),
(29, 'it-IT', 2, 'per Item', 'por artículo', '2022-02-01 20:57:26', 1, NULL),
(30, 'it-IT', 3, 'Cost', 'Costo', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `resourcetype`
--

DROP TABLE IF EXISTS `resourcetype`;
CREATE TABLE IF NOT EXISTS `resourcetype` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `resourcetype`
--

INSERT INTO `resourcetype` (`Id`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, '1', 'Material resources', '2014-04-11 08:06:51', 1, NULL),
(2, '2', 'Human resource', '2014-04-11 08:07:04', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `resourcetypelocalized`
--

DROP TABLE IF EXISTS `resourcetypelocalized`;
CREATE TABLE IF NOT EXISTS `resourcetypelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `ParentId` bigint(20) NOT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `Name` varchar(256) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `CreatedBy` (`CreatedBy`),
  KEY `FK_resourcetype_reosurcetypelocalized` (`ParentId`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `resourcetypelocalized`
--

INSERT INTO `resourcetypelocalized` (`Id`, `LanguageCode`, `ParentId`, `Code`, `Name`, `DateCreated`, `CreatedBy`, `DeactivationDate`) VALUES
(1, 'sr-Latn-RS', 1, '1', 'Materijalni resursi', '2014-04-11 08:06:51', 1, NULL),
(2, 'en-US', 1, '1', 'Material resources', '2014-04-11 08:06:51', 1, NULL),
(3, 'sr-Latn-RS', 2, '2', 'Ljudski resursi', '2014-04-11 08:07:04', 1, NULL),
(4, 'en-US', 2, '2', 'Human resource', '2014-04-11 08:07:04', 1, NULL),
(5, 'en-AU', 1, '1', 'Material resources', '2014-04-11 08:06:51', 1, NULL),
(6, 'en-AU', 2, '2', 'Human resource', '2014-04-11 08:07:04', 1, NULL),
(8, 'bs-BA', 1, '1', 'Materijalni resursi', '2014-04-11 08:06:51', 1, NULL),
(9, 'bs-BA', 2, '2', 'Ljudski resursi', '2014-04-11 08:07:04', 1, NULL),
(11, 'hr-HR', 1, '1', 'Materijalni resursi', '2014-04-11 08:06:51', 1, NULL),
(12, 'hr-HR', 2, '2', 'Ljudski resursi', '2014-04-11 08:07:04', 1, NULL),
(14, 'de-DE', 1, '1', 'Materielle Ressourcen', '2014-04-11 08:06:51', 1, NULL),
(15, 'de-DE', 2, '2', 'Personal', '2014-04-11 08:07:04', 1, NULL),
(16, 'es-ES', 1, '1', 'Recursos materiales', '2020-04-16 23:25:39', 1, NULL),
(17, 'es-ES', 2, '2', 'Recursos humanos', '2020-04-16 23:25:39', 1, NULL),
(18, 'en-GB', 1, '1', 'Material resources', '2022-02-01 20:57:25', 1, NULL),
(19, 'en-GB', 2, '2', 'Human resource', '2022-02-01 20:57:25', 1, NULL),
(20, 'en-UK', 1, '1', 'Materialni viri', '2022-02-01 20:57:26', 1, NULL),
(21, 'en-UK', 2, '2', 'Človeški viri', '2022-02-01 20:57:26', 1, NULL),
(22, 'it-IT', 1, '1', 'Risorse materiali', '2022-02-01 20:57:26', 1, NULL),
(23, 'it-IT', 2, '2', 'Risorse umane', '2022-02-01 20:57:26', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `risk`
--

DROP TABLE IF EXISTS `risk`;
CREATE TABLE IF NOT EXISTS `risk` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `Name` varchar(512) NOT NULL,
  `Description` varchar(2048) DEFAULT NULL,
  `IsClosed` bit(1) NOT NULL,
  `Informee` varchar(512) DEFAULT NULL,
  `InformationDate` datetime DEFAULT NULL,
  `ResolveUntil` datetime DEFAULT NULL,
  `Influence` bigint(20) NOT NULL,
  `Priority` bigint(20) NOT NULL,
  `SolveDate` datetime DEFAULT NULL,
  `SolveDescription` varchar(2048) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `riskactivity`
--

DROP TABLE IF EXISTS `riskactivity`;
CREATE TABLE IF NOT EXISTS `riskactivity` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `RiskId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `RiskId` (`RiskId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `riskdocument`
--

DROP TABLE IF EXISTS `riskdocument`;
CREATE TABLE IF NOT EXISTS `riskdocument` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `RiskId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `RiskId` (`RiskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `riskdocumentnote`
--

DROP TABLE IF EXISTS `riskdocumentnote`;
CREATE TABLE IF NOT EXISTS `riskdocumentnote` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `DocumentName` varchar(70) NOT NULL,
  `RiskUpdateId` bigint(20) NOT NULL,
  `OriginId` bigint(20) DEFAULT NULL,
  `UploadType` int(11) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` varchar(250) DEFAULT NULL,
  `FileName` varchar(70) NOT NULL,
  `ContentLength` longtext DEFAULT NULL,
  `FilePath` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `RiskUpdateId` (`RiskUpdateId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `riskupdate`
--

DROP TABLE IF EXISTS `riskupdate`;
CREATE TABLE IF NOT EXISTS `riskupdate` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `RiskUpdate` longtext NOT NULL,
  `RiskId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `RiskId` (`RiskId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `riskuser`
--

DROP TABLE IF EXISTS `riskuser`;
CREATE TABLE IF NOT EXISTS `riskuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `RiskId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `RiskId` (`RiskId`),
  KEY `UserId` (`UserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
CREATE TABLE IF NOT EXISTS `role` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `IsProjectManager` tinyint(4) NOT NULL DEFAULT 0,
  `IsSuperAdmin` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `role`
--

INSERT INTO `role` (`Id`, `Name`, `DateCreated`, `CreatedBy`, `Description`, `DeactivationDate`, `IsProjectManager`, `IsSuperAdmin`) VALUES
(1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL, 0, 1),
(2, 'Projekt menadžer', '2014-04-11 07:29:18', 1, NULL, NULL, 1, 0),
(3, 'Član tima', '2014-04-11 07:41:28', 1, NULL, NULL, 0, 0),
(4, 'Pregled projekata', '2014-04-11 07:45:02', 1, NULL, NULL, 0, 0),
(5, 'Tester softvera', '2016-10-18 07:11:03', 1, NULL, NULL, 0, 0),
(6, 'Team leader', '2016-12-03 18:27:14', 1, NULL, NULL, 0, 0),
(7, 'Eksterni član tima', '2020-04-21 00:00:00', 1, NULL, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `rolelocalized`
--

DROP TABLE IF EXISTS `rolelocalized`;
CREATE TABLE IF NOT EXISTS `rolelocalized` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `LanguageCode` varchar(20) NOT NULL,
  `RoleId` bigint(20) NOT NULL,
  `Name` varchar(100) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `Description` longtext DEFAULT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rolelocalized`
--

INSERT INTO `rolelocalized` (`Id`, `LanguageCode`, `RoleId`, `Name`, `DateCreated`, `CreatedBy`, `Description`, `DeactivationDate`) VALUES
(1, 'en-US', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(2, 'sr-Latn-RS', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(3, 'sr-Latn-RS', 2, 'Projekt menadžer', '2014-04-11 07:29:19', 1, NULL, NULL),
(4, 'en-US', 2, 'Project Manager', '2014-04-11 07:29:19', 1, NULL, NULL),
(5, 'sr-Latn-RS', 3, 'Član tima', '2014-04-11 07:41:28', 1, NULL, NULL),
(6, 'en-US', 3, 'Team member', '2014-04-11 07:41:28', 1, NULL, NULL),
(7, 'sr-Latn-RS', 4, 'Pregled projekata', '2014-04-11 07:45:02', 1, NULL, NULL),
(8, 'en-US', 4, 'Project overview', '2014-04-11 07:45:02', 1, NULL, NULL),
(9, 'sr-Latn-RS', 5, 'Tester softvera', '2016-10-18 07:11:04', 1, NULL, NULL),
(10, 'en-US', 5, 'Software tester', '2016-10-18 07:11:04', 1, NULL, NULL),
(11, 'sr-Latn-RS', 6, 'Tim lider', '2016-12-03 18:27:14', 1, NULL, NULL),
(12, 'en-US', 6, 'Team leader', '2016-12-03 18:27:14', 1, NULL, NULL),
(13, 'en-AU', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(14, 'en-AU', 2, 'Project Manager', '2014-04-11 07:29:19', 1, NULL, NULL),
(15, 'en-AU', 3, 'Team member', '2014-04-11 07:41:28', 1, NULL, NULL),
(16, 'en-AU', 4, 'Project overview', '2014-04-11 07:45:02', 1, NULL, NULL),
(17, 'en-AU', 5, 'Software tester', '2016-10-18 07:11:04', 1, NULL, NULL),
(18, 'en-AU', 6, 'Team leader', '2016-12-03 18:27:14', 1, NULL, NULL),
(20, 'bs-BA', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(21, 'bs-BA', 2, 'Projekt menadžer', '2014-04-11 07:29:19', 1, NULL, NULL),
(22, 'bs-BA', 3, 'Član tima', '2014-04-11 07:41:28', 1, NULL, NULL),
(23, 'bs-BA', 4, 'Pregled projekata', '2014-04-11 07:45:02', 1, NULL, NULL),
(24, 'bs-BA', 5, 'Tester softvera', '2016-10-18 07:11:04', 1, NULL, NULL),
(25, 'bs-BA', 6, 'Tim lider', '2016-12-03 18:27:14', 1, NULL, NULL),
(27, 'hr-HR', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(28, 'hr-HR', 2, 'Projekt menadžer', '2014-04-11 07:29:19', 1, NULL, NULL),
(29, 'hr-HR', 3, 'Član tima', '2014-04-11 07:41:28', 1, NULL, NULL),
(30, 'hr-HR', 4, 'Pregled projekata', '2014-04-11 07:45:02', 1, NULL, NULL),
(31, 'hr-HR', 5, 'Tester softvera', '2016-10-18 07:11:04', 1, NULL, NULL),
(32, 'hr-HR', 6, 'Tim lider', '2016-12-03 18:27:14', 1, NULL, NULL),
(34, 'de-DE', 1, 'Super Admin', '2014-04-10 00:45:24', 1, NULL, NULL),
(35, 'de-DE', 2, 'Projektmanager', '2014-04-11 07:29:19', 1, NULL, NULL),
(36, 'de-DE', 3, 'Teammitglied', '2014-04-11 07:41:28', 1, NULL, NULL),
(37, 'de-DE', 4, 'Projektübersicht', '2014-04-11 07:45:02', 1, NULL, NULL),
(38, 'de-DE', 5, 'Softwaretester', '2016-10-18 07:11:04', 1, NULL, NULL),
(39, 'de-DE', 6, 'Gruppenführer', '2016-12-03 18:27:14', 1, NULL, NULL),
(40, 'es-ES', 1, 'Super administrador', '2020-04-16 23:25:39', 1, NULL, NULL),
(41, 'es-ES', 2, 'Gerente de proyecto', '2020-04-16 23:25:39', 1, NULL, NULL),
(42, 'es-ES', 3, 'Miembro del equipo', '2020-04-16 23:25:39', 1, NULL, NULL),
(43, 'es-ES', 4, 'Resumen del proyecto', '2020-04-16 23:25:39', 1, NULL, NULL),
(44, 'es-ES', 5, 'Probador de software', '2020-04-16 23:25:40', 1, NULL, NULL),
(45, 'es-ES', 6, 'Capitán del equipo', '2020-04-16 23:25:40', 1, NULL, NULL),
(46, 'sr-Latn-RS', 7, 'Eksterni član tima', '2020-04-21 00:00:00', 1, NULL, NULL),
(47, 'en-US', 7, 'External team member', '2020-04-21 00:00:00', 1, NULL, NULL),
(48, 'en-AU', 7, 'External team member', '2020-04-21 00:00:00', 1, NULL, NULL),
(49, 'bs-BA', 7, 'Eksterni član tima', '2020-04-21 00:00:00', 1, NULL, NULL),
(50, 'hr-HR', 7, 'Eksterni član tima', '2020-04-21 00:00:00', 1, NULL, NULL),
(51, 'de-DE', 7, 'Externes Teammitglied', '2020-04-21 00:00:00', 1, NULL, NULL),
(52, 'es-ES', 7, 'Miembro del equipo externo', '2020-04-21 00:00:00', 1, NULL, NULL),
(53, 'en-GB', 1, 'Super Admin', '2022-02-01 20:57:25', 1, NULL, NULL),
(54, 'en-GB', 2, 'Project Manager', '2022-02-01 20:57:25', 1, NULL, NULL),
(55, 'en-GB', 3, 'Team member', '2022-02-01 20:57:25', 1, NULL, NULL),
(56, 'en-GB', 4, 'Project overview', '2022-02-01 20:57:25', 1, NULL, NULL),
(57, 'en-GB', 5, 'Software tester', '2022-02-01 20:57:25', 1, NULL, NULL),
(58, 'en-GB', 6, 'Team leader', '2022-02-01 20:57:25', 1, NULL, NULL),
(59, 'en-UK', 1, 'Super Admin', '2022-02-01 20:57:26', 1, NULL, NULL),
(60, 'en-UK', 2, 'Menedžer projekta', '2022-02-01 20:57:26', 1, NULL, NULL),
(61, 'en-UK', 3, 'Član ekipe', '2022-02-01 20:57:26', 1, NULL, NULL),
(62, 'en-UK', 4, 'Pregled projektov', '2022-02-01 20:57:26', 1, NULL, NULL),
(63, 'en-UK', 5, 'Testni inženir', '2022-02-01 20:57:26', 1, NULL, NULL),
(64, 'en-UK', 6, 'Vodja ekipe', '2022-02-01 20:57:26', 1, NULL, NULL),
(65, 'it-IT', 1, 'Super amministratore', '2022-02-01 20:57:26', 1, NULL, NULL),
(66, 'it-IT', 2, 'Project Manager', '2022-02-01 20:57:26', 1, NULL, NULL),
(67, 'it-IT', 3, 'Membro del team', '2022-02-01 20:57:26', 1, NULL, NULL),
(68, 'it-IT', 4, 'Visualizzazione del progetto', '2022-02-01 20:57:26', 1, NULL, NULL),
(69, 'it-IT', 5, 'Tester del software', '2022-02-01 20:57:26', 1, NULL, NULL),
(70, 'it-IT', 6, 'Guida del gruppo', '2022-02-01 20:57:26', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `rolepermission`
--

DROP TABLE IF EXISTS `rolepermission`;
CREATE TABLE IF NOT EXISTS `rolepermission` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `RoleId` bigint(20) NOT NULL,
  `PermissionId` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `PermissionId` (`PermissionId`),
  KEY `RoleId` (`RoleId`)
) ENGINE=InnoDB AUTO_INCREMENT=43565 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `rolepermission`
--

INSERT INTO `rolepermission` (`Id`, `RoleId`, `PermissionId`) VALUES
(42769, 3, 99),
(42770, 3, 108),
(42771, 3, 107),
(42772, 3, 91),
(42773, 3, 90),
(42774, 3, 89),
(42775, 3, 83),
(42776, 3, 79),
(42777, 3, 71),
(42778, 3, 111),
(42779, 3, 64),
(42780, 3, 58),
(42781, 3, 54),
(42782, 3, 49),
(42783, 3, 45),
(42784, 3, 42),
(42785, 3, 106),
(42786, 3, 104),
(42787, 3, 38),
(42788, 3, 34),
(42789, 3, 110),
(42790, 3, 109),
(42791, 3, 21),
(42792, 3, 20),
(42793, 3, 17),
(42794, 3, 16),
(42795, 3, 15),
(42796, 3, 4),
(42797, 3, 3),
(42798, 3, 103),
(42799, 5, 99),
(42800, 5, 108),
(42801, 5, 107),
(42802, 5, 90),
(42803, 5, 89),
(42804, 5, 83),
(42805, 5, 79),
(42806, 5, 75),
(42807, 5, 74),
(42808, 5, 71),
(42809, 5, 111),
(42810, 5, 64),
(42811, 5, 58),
(42812, 5, 54),
(42813, 5, 49),
(42814, 5, 45),
(42815, 5, 42),
(42816, 5, 106),
(42817, 5, 104),
(42818, 5, 38),
(42819, 5, 34),
(42820, 5, 110),
(42821, 5, 109),
(42822, 5, 21),
(42823, 5, 20),
(42824, 5, 17),
(42825, 5, 16),
(42826, 5, 15),
(42827, 5, 4),
(42828, 5, 3),
(42829, 5, 103),
(43064, 6, 103),
(43065, 6, 102),
(43066, 6, 101),
(43067, 6, 99),
(43068, 6, 108),
(43069, 6, 107),
(43070, 6, 91),
(43071, 6, 90),
(43072, 6, 89),
(43073, 6, 83),
(43074, 6, 82),
(43075, 6, 81),
(43076, 6, 80),
(43077, 6, 79),
(43078, 6, 75),
(43079, 6, 74),
(43080, 6, 73),
(43081, 6, 71),
(43082, 6, 111),
(43083, 6, 64),
(43084, 6, 63),
(43085, 6, 62),
(43086, 6, 61),
(43087, 6, 58),
(43088, 6, 54),
(43089, 6, 49),
(43090, 6, 45),
(43091, 6, 42),
(43092, 6, 41),
(43093, 6, 40),
(43094, 6, 39),
(43095, 6, 106),
(43096, 6, 104),
(43097, 6, 38),
(43098, 6, 37),
(43099, 6, 36),
(43100, 6, 35),
(43101, 6, 34),
(43102, 6, 110),
(43103, 6, 109),
(43104, 6, 21),
(43105, 6, 20),
(43106, 6, 19),
(43107, 6, 18),
(43108, 6, 17),
(43109, 6, 16),
(43110, 6, 15),
(43111, 6, 14),
(43112, 6, 13),
(43113, 6, 12),
(43114, 6, 11),
(43115, 6, 6),
(43116, 6, 5),
(43117, 6, 4),
(43118, 6, 3),
(43119, 6, 2),
(43120, 6, 1),
(43300, 2, 99),
(43301, 2, 98),
(43302, 2, 97),
(43303, 2, 96),
(43304, 2, 108),
(43305, 2, 107),
(43306, 2, 91),
(43307, 2, 90),
(43308, 2, 89),
(43309, 2, 88),
(43310, 2, 87),
(43311, 2, 83),
(43312, 2, 82),
(43313, 2, 81),
(43314, 2, 80),
(43315, 2, 116),
(43316, 2, 114),
(43317, 2, 115),
(43318, 2, 113),
(43319, 2, 79),
(43320, 2, 75),
(43321, 2, 74),
(43322, 2, 73),
(43323, 2, 72),
(43324, 2, 71),
(43325, 2, 70),
(43326, 2, 69),
(43327, 2, 68),
(43328, 2, 111),
(43329, 2, 67),
(43330, 2, 66),
(43331, 2, 65),
(43332, 2, 64),
(43333, 2, 63),
(43334, 2, 62),
(43335, 2, 61),
(43336, 2, 59),
(43337, 2, 58),
(43338, 2, 57),
(43339, 2, 56),
(43340, 2, 55),
(43341, 2, 54),
(43342, 2, 53),
(43343, 2, 52),
(43344, 2, 51),
(43345, 2, 49),
(43346, 2, 48),
(43347, 2, 47),
(43348, 2, 46),
(43349, 2, 45),
(43350, 2, 44),
(43351, 2, 43),
(43352, 2, 42),
(43353, 2, 41),
(43354, 2, 40),
(43355, 2, 39),
(43356, 2, 106),
(43357, 2, 104),
(43358, 2, 38),
(43359, 2, 37),
(43360, 2, 36),
(43361, 2, 35),
(43362, 2, 34),
(43363, 2, 110),
(43364, 2, 109),
(43365, 2, 21),
(43366, 2, 20),
(43367, 2, 19),
(43368, 2, 18),
(43369, 2, 17),
(43370, 2, 16),
(43371, 2, 15),
(43372, 2, 14),
(43373, 2, 13),
(43374, 2, 12),
(43375, 2, 11),
(43376, 2, 6),
(43377, 2, 5),
(43378, 2, 4),
(43379, 2, 3),
(43380, 2, 2),
(43381, 2, 1),
(43382, 2, 100),
(43383, 2, 101),
(43384, 2, 102),
(43385, 2, 103),
(43386, 2, 112),
(43387, 4, 99),
(43388, 4, 108),
(43389, 4, 90),
(43390, 4, 89),
(43391, 4, 83),
(43392, 4, 116),
(43393, 4, 79),
(43394, 4, 71),
(43395, 4, 111),
(43396, 4, 64),
(43397, 4, 58),
(43398, 4, 54),
(43399, 4, 49),
(43400, 4, 45),
(43401, 4, 42),
(43402, 4, 106),
(43403, 4, 104),
(43404, 4, 38),
(43405, 4, 34),
(43406, 4, 110),
(43407, 4, 109),
(43408, 4, 21),
(43409, 4, 20),
(43410, 4, 17),
(43411, 4, 16),
(43412, 4, 15),
(43413, 4, 4),
(43414, 4, 103),
(43415, 1, 100),
(43416, 1, 99),
(43417, 1, 98),
(43418, 1, 97),
(43419, 1, 96),
(43420, 1, 108),
(43421, 1, 107),
(43422, 1, 91),
(43423, 1, 90),
(43424, 1, 89),
(43425, 1, 88),
(43426, 1, 87),
(43427, 1, 83),
(43428, 1, 82),
(43429, 1, 81),
(43430, 1, 80),
(43431, 1, 116),
(43432, 1, 114),
(43433, 1, 115),
(43434, 1, 113),
(43435, 1, 79),
(43436, 1, 75),
(43437, 1, 74),
(43438, 1, 73),
(43439, 1, 72),
(43440, 1, 71),
(43441, 1, 70),
(43442, 1, 69),
(43443, 1, 68),
(43444, 1, 111),
(43445, 1, 67),
(43446, 1, 66),
(43447, 1, 65),
(43448, 1, 64),
(43449, 1, 63),
(43450, 1, 62),
(43451, 1, 61),
(43452, 1, 60),
(43453, 1, 59),
(43454, 1, 58),
(43455, 1, 57),
(43456, 1, 56),
(43457, 1, 55),
(43458, 1, 54),
(43459, 1, 53),
(43460, 1, 52),
(43461, 1, 51),
(43462, 1, 50),
(43463, 1, 49),
(43464, 1, 48),
(43465, 1, 47),
(43466, 1, 46),
(43467, 1, 45),
(43468, 1, 44),
(43469, 1, 43),
(43470, 1, 42),
(43471, 1, 41),
(43472, 1, 40),
(43473, 1, 39),
(43474, 1, 106),
(43475, 1, 104),
(43476, 1, 38),
(43477, 1, 37),
(43478, 1, 36),
(43479, 1, 35),
(43480, 1, 34),
(43481, 1, 110),
(43482, 1, 109),
(43483, 1, 33),
(43484, 1, 32),
(43485, 1, 31),
(43486, 1, 30),
(43487, 1, 29),
(43488, 1, 28),
(43489, 1, 27),
(43490, 1, 26),
(43491, 1, 25),
(43492, 1, 24),
(43493, 1, 23),
(43494, 1, 22),
(43495, 1, 21),
(43496, 1, 20),
(43497, 1, 19),
(43498, 1, 18),
(43499, 1, 17),
(43500, 1, 16),
(43501, 1, 15),
(43502, 1, 14),
(43503, 1, 13),
(43504, 1, 12),
(43505, 1, 11),
(43506, 1, 6),
(43507, 1, 5),
(43508, 1, 4),
(43509, 1, 3),
(43510, 1, 2),
(43511, 1, 1),
(43512, 1, 101),
(43513, 1, 102),
(43514, 1, 103),
(43515, 1, 112),
(43516, 3, 5),
(43517, 3, 13),
(43518, 3, 14),
(43519, 3, 40),
(43520, 3, 62),
(43521, 3, 63),
(43522, 3, 74),
(43523, 3, 81),
(43524, 3, 101),
(43525, 3, 102),
(43526, 7, 99),
(43527, 7, 108),
(43528, 7, 107),
(43529, 7, 89),
(43530, 7, 83),
(43531, 7, 79),
(43532, 7, 71),
(43533, 7, 111),
(43534, 7, 64),
(43535, 7, 58),
(43536, 7, 54),
(43537, 7, 49),
(43538, 7, 45),
(43539, 7, 42),
(43540, 7, 106),
(43541, 7, 104),
(43542, 7, 38),
(43543, 7, 34),
(43544, 7, 110),
(43545, 7, 109),
(43546, 7, 21),
(43547, 7, 20),
(43548, 7, 17),
(43549, 7, 16),
(43550, 7, 15),
(43551, 7, 4),
(43552, 7, 3),
(43553, 7, 103),
(43554, 7, 5),
(43555, 7, 13),
(43556, 7, 14),
(43557, 7, 40),
(43558, 7, 62),
(43559, 7, 63),
(43560, 7, 74),
(43561, 7, 81),
(43562, 7, 101),
(43563, 7, 102),
(43564, 7, 90);

-- --------------------------------------------------------

--
-- Table structure for table `tabelaakt1`
--

DROP TABLE IF EXISTS `tabelaakt1`;
CREATE TABLE IF NOT EXISTS `tabelaakt1` (
  `nomenclature` varchar(20) DEFAULT NULL,
  `nomnumb` varchar(20) NOT NULL,
  `Nivo` int(11) DEFAULT NULL,
  `Name` varchar(500) DEFAULT NULL,
  `StartDate` datetime DEFAULT NULL,
  `EndDate` datetime DEFAULT NULL,
  `Progress` int(11) DEFAULT NULL,
  `id` bigint(20) DEFAULT NULL,
  `parentid` bigint(20) DEFAULT NULL,
  `ActivityUsers` varchar(500) DEFAULT NULL,
  `Price` decimal(18,3) DEFAULT NULL,
  `Currency` varchar(5) DEFAULT NULL,
  `projectId` bigint(20) NOT NULL,
  `userId` varchar(50) NOT NULL,
  `Summary` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tabelaakt2`
--

DROP TABLE IF EXISTS `tabelaakt2`;
CREATE TABLE IF NOT EXISTS `tabelaakt2` (
  `nomenclature` varchar(20) DEFAULT NULL,
  `Nivo` int(11) DEFAULT NULL,
  `Name` varchar(500) DEFAULT NULL,
  `StartDate` datetime DEFAULT NULL,
  `EndDate` datetime DEFAULT NULL,
  `Progress` int(11) DEFAULT NULL,
  `id` bigint(20) DEFAULT NULL,
  `parentid` bigint(20) DEFAULT NULL,
  `ActivityUsers` varchar(500) DEFAULT NULL,
  `Price` decimal(18,3) DEFAULT NULL,
  `Currency` varchar(5) DEFAULT NULL,
  `projectId` bigint(20) NOT NULL,
  `userId` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `task`
--

DROP TABLE IF EXISTS `task`;
CREATE TABLE IF NOT EXISTS `task` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `Name` varchar(512) NOT NULL,
  `Description` varchar(2048) DEFAULT NULL,
  `IsClosed` tinyint(4) NOT NULL,
  `ResolveUntil` datetime DEFAULT NULL,
  `SolveDate` datetime DEFAULT NULL,
  `SolveDescription` varchar(2048) DEFAULT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `ActivityId` bigint(20) DEFAULT NULL,
  `TaskDate` datetime DEFAULT NULL,
  `PriorityId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `PriorityId` (`PriorityId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `taskuser`
--

DROP TABLE IF EXISTS `taskuser`;
CREATE TABLE IF NOT EXISTS `taskuser` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `TaskId` bigint(20) NOT NULL,
  `UserId` bigint(20) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `UserId` (`UserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `timeuse`
--

DROP TABLE IF EXISTS `timeuse`;
CREATE TABLE IF NOT EXISTS `timeuse` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ProjectId` bigint(20) NOT NULL,
  `ActivityId` bigint(20) DEFAULT NULL,
  `UserId` bigint(20) NOT NULL,
  `TimeUseDate` datetime NOT NULL,
  `Hours` int(11) NOT NULL,
  `Minutes` int(11) NOT NULL,
  `Payable` bit(1) DEFAULT NULL,
  `Amount` decimal(18,2) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) NOT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `Description` longtext DEFAULT NULL,
  `DateUpdated` datetime NOT NULL,
  `UpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ActivityId` (`ActivityId`),
  KEY `ProjectId` (`ProjectId`),
  KEY `UserId` (`UserId`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE IF NOT EXISTS `user` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `Name` varchar(250) NOT NULL,
  `UserName` varchar(50) NOT NULL,
  `Password` varchar(250) NOT NULL,
  `Email` varchar(250) NOT NULL,
  `DateCreated` datetime NOT NULL,
  `CreatedBy` bigint(20) DEFAULT NULL,
  `AvatarFileName` varchar(255) DEFAULT NULL,
  `DeactivationDate` datetime DEFAULT NULL,
  `RoleId` bigint(20) NOT NULL DEFAULT 3,
  `RoleIdProject` bigint(20) DEFAULT NULL,
  `IsDojo` bit(1) DEFAULT NULL,
  `IsReport` bit(1) DEFAULT NULL,
  `IsCEO` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`),
  KEY `RoleId` (`RoleId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user`
--

INSERT INTO `user` (`Id`, `Name`, `UserName`, `Password`, `Email`, `DateCreated`, `CreatedBy`, `AvatarFileName`, `DeactivationDate`, `RoleId`, `RoleIdProject`, `IsDojo`, `IsReport`, `IsCEO`) VALUES
(1, 'Administrator', 'admin', 'EAAAAHEShKVmeHBwF9oPQipk5n1NKBlG5fxCDHCxPl/b4mNf', 'admin@nexsto.com', '2017-01-22 14:30:25', 1, NULL, NULL, 1, 2, b'1', b'1', 0);

-- --------------------------------------------------------

--
-- Table structure for table `userproject`
--

DROP TABLE IF EXISTS `userproject`;
CREATE TABLE IF NOT EXISTS `userproject` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `UserId` bigint(20) NOT NULL,
  `ProjectId` bigint(20) NOT NULL,
  `RoleId` bigint(20) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `ProjectId` (`ProjectId`),
  KEY `RoleId` (`RoleId`),
  KEY `UserId` (`UserId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Stand-in structure for view `viewmessage`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `viewmessage`;
CREATE TABLE IF NOT EXISTS `viewmessage` (
`Id` bigint(20)
,`Type` int(11)
,`Title` varchar(1024)
,`Body` longtext
,`Url` varchar(2048)
,`Folder` tinyint(4)
,`Comment` longtext
,`CreatedBy` bigint(20)
,`DateCreated` datetime
,`ProjectName` varchar(500)
,`IsRead` tinyint(4)
,`IsReplayed` tinyint(4)
,`IsForwarded` tinyint(4)
,`IsDeleted` tinyint(4)
,`UserName` varchar(250)
,`UserId` bigint(20)
,`MessageUserId` bigint(20)
,`DateSendReceived` datetime
,`MessagePriority` int(11)
,`DeactivationDate` datetime
);

-- --------------------------------------------------------

--
-- Structure for view `viewmessage`
--
DROP TABLE IF EXISTS `viewmessage`;

DROP VIEW IF EXISTS `viewmessage`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewmessage`  AS SELECT `message`.`Id` AS `Id`, `message`.`Type` AS `Type`, `message`.`Title` AS `Title`, `message`.`Body` AS `Body`, `message`.`Url` AS `Url`, `message`.`Folder` AS `Folder`, `message`.`Comment` AS `Comment`, `message`.`CreatedBy` AS `CreatedBy`, `message`.`DateCreated` AS `DateCreated`, `project`.`Name` AS `ProjectName`, `messageuser`.`IsRead` AS `IsRead`, `messageuser`.`IsReplayed` AS `IsReplayed`, `messageuser`.`IsForwarded` AS `IsForwarded`, `messageuser`.`IsDeleted` AS `IsDeleted`, `user`.`Name` AS `UserName`, `messageuser`.`UserId` AS `UserId`, `messageuser`.`Id` AS `MessageUserId`, `message`.`DateSentReceived` AS `DateSendReceived`, `message`.`MessagePriority` AS `MessagePriority`, `messageuser`.`DeactivationDate` AS `DeactivationDate` FROM (((`message` join `messageuser` on(`message`.`Id` = `messageuser`.`MessageId`)) left join `project` on(`message`.`ProjectId` = `project`.`Id`)) left join `user` on(`message`.`CreatedBy` = `user`.`Id`)) ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `activityresource`
--
ALTER TABLE `activityresource`
  ADD CONSTRAINT `FK_ProjectResourceId` FOREIGN KEY (`ProjectResourceId`) REFERENCES `projectresource` (`Id`);

--
-- Constraints for table `kanbancolumnslocalized`
--
ALTER TABLE `kanbancolumnslocalized`
  ADD CONSTRAINT `kanbancolumnslocalized_ibfk_1` FOREIGN KEY (`ParentId`) REFERENCES `kanbancolumn` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `projectresource`
--
ALTER TABLE `projectresource`
  ADD CONSTRAINT `FK_projectresource_reosurcetype` FOREIGN KEY (`ResourceTypeId`) REFERENCES `resourcetype` (`Id`);

--
-- Constraints for table `resource`
--
ALTER TABLE `resource`
  ADD CONSTRAINT `FK_resource_reosurcetype` FOREIGN KEY (`ResourceTypeId`) REFERENCES `resourcetype` (`Id`);

--
-- Constraints for table `resourcetypelocalized`
--
ALTER TABLE `resourcetypelocalized`
  ADD CONSTRAINT `FK_resourcetype_reosurcetypelocalized` FOREIGN KEY (`ParentId`) REFERENCES `resourcetype` (`Id`);
SET FOREIGN_KEY_CHECKS=1;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
